/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rank;

import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_player_rank_path", uniqueConstraints={@UniqueConstraint(columnNames={"player_id", "rank_tree_id"})})
public class RPlayerRankPath
extends BaseEntity {
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="player_id", nullable=false)
    private RDQPlayer player;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rank_tree_id", nullable=false)
    private RRankTree selectedRankPath;
    @Column(name="is_active", nullable=false)
    private boolean isActive;
    @Column(name="is_completed", nullable=false)
    private boolean isCompleted = false;
    @Column(name="completed_at", nullable=true)
    private LocalDateTime completedAt;

    protected RPlayerRankPath() {
    }

    public RPlayerRankPath(@NotNull RDQPlayer player, @NotNull RRankTree selectedRankPath, boolean isActive) {
        this.player = player;
        this.selectedRankPath = selectedRankPath;
        this.isActive = isActive;
    }

    public RPlayerRankPath(@NotNull RDQPlayer rdqPlayer, @NotNull RRankTree selectedRankPath) {
        this(rdqPlayer, selectedRankPath, true);
    }

    public RDQPlayer getRdqPlayer() {
        return this.player;
    }

    public void setRdqPlayer(@NotNull RDQPlayer player) {
        this.player = player;
    }

    public void setSelectedRankPath(@NotNull RRankTree selectedRankPath) {
        this.selectedRankPath = selectedRankPath;
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
        if (completed && this.completedAt == null) {
            this.completedAt = LocalDateTime.now();
        } else if (!completed) {
            this.completedAt = null;
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void markAsCompleted() {
        this.setCompleted(true);
    }

    public boolean isRecentlySelected() {
        return this.getCreatedAt() != null && this.getCreatedAt().isAfter(LocalDateTime.now().minusHours(1L));
    }

    @Override
    public String toString() {
        return "RDQPlayerRankPath{player=" + (this.player != null ? this.player.getPlayerName() : "null") + ", rankTree=" + (this.selectedRankPath != null ? this.selectedRankPath.getIdentifier() : "null") + ", isActive=" + this.isActive + ", isCompleted=" + this.isCompleted + "}";
    }

    @Generated
    public RDQPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public RRankTree getSelectedRankPath() {
        return this.selectedRankPath;
    }

    @Generated
    public boolean isActive() {
        return this.isActive;
    }

    @Generated
    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Generated
    public LocalDateTime getCompletedAt() {
        return this.completedAt;
    }
}

