/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rank;

import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_player_rank", uniqueConstraints={@UniqueConstraint(columnNames={"player_id", "rank_tree_id"})})
public class RPlayerRank
extends BaseEntity {
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="player_id", nullable=false)
    private RDQPlayer player;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="current_rank_id", nullable=false)
    private RRank currentRank;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rank_tree_id")
    private RRankTree rankTree;
    @Column(name="is_active", nullable=false)
    private boolean isActive = true;

    protected RPlayerRank() {
    }

    public RPlayerRank(@NotNull RDQPlayer player, @NotNull RRank currentRank, @NotNull RRankTree rankTree) {
        this.player = player;
        this.currentRank = currentRank;
        this.rankTree = rankTree;
    }

    public RPlayerRank(@NotNull RDQPlayer player, @NotNull RRank currentRank, @NotNull RRankTree rankTree, boolean isActive) {
        this.player = player;
        this.currentRank = currentRank;
        this.rankTree = rankTree;
        this.isActive = isActive;
    }

    public RPlayerRank(@NotNull RDQPlayer player, @NotNull RRank rank) {
        this.player = player;
        this.currentRank = rank;
        this.rankTree = rank.getRankTree();
    }

    public RDQPlayer getRdqPlayer() {
        return this.player;
    }

    public void setRdqPlayer(@NotNull RDQPlayer player) {
        this.player = player;
    }

    public RRank getCurrentRank() {
        return this.currentRank;
    }

    public void setCurrentRank(@NotNull RRank currentRank) {
        this.currentRank = currentRank;
    }

    public RRankTree getRankTree() {
        return this.rankTree;
    }

    public void setRankTree(@NotNull RRankTree rankTree) {
        this.rankTree = rankTree;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public boolean belongsToRankTree(@NotNull RRankTree rankTree) {
        return this.rankTree != null && this.rankTree.equals(rankTree);
    }

    public boolean belongsToRankTree(@NotNull String rankTreeIdentifier) {
        return this.rankTree != null && this.rankTree.getIdentifier() != null && this.rankTree.getIdentifier().equals(rankTreeIdentifier);
    }

    @Override
    public String toString() {
        return "RPlayerRank{player=" + (this.player != null ? this.player.getPlayerName() : "null") + ", currentRank=" + (this.currentRank != null ? this.currentRank.getIdentifier() : "null") + ", rankTree=" + (this.rankTree != null ? this.rankTree.getIdentifier() : "null") + ", isActive=" + this.isActive + "}";
    }
}

