/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.player;

import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankPath;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="rdq_player")
public class RDQPlayer
extends BaseEntity {
    @Column(name="unique_id", unique=true, nullable=false)
    private UUID uniqueId;
    @Column(name="player_name", nullable=false)
    private String playerName;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="player")
    private List<RPlayerRank> playerRanks = new ArrayList<RPlayerRank>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="player")
    private List<RPlayerRankPath> playerRankPaths = new ArrayList<RPlayerRankPath>();

    protected RDQPlayer() {
    }

    public RDQPlayer(@NotNull UUID uniqueId, @NotNull String playerName) {
        this.uniqueId = uniqueId;
        this.playerName = playerName;
    }

    public RDQPlayer(@NotNull Player player) {
        this(player.getUniqueId(), player.getName());
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public List<RPlayerRank> getPlayerRanks() {
        return this.playerRanks;
    }

    public List<RPlayerRankPath> getPlayerRankPaths() {
        return this.playerRankPaths;
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public void setPlayerRanks(List<RPlayerRank> playerRanks) {
        this.playerRanks = playerRanks != null ? playerRanks : new ArrayList();
    }

    public void addPlayerRank(@NotNull RPlayerRank playerRank) {
        if (this.playerRanks == null) {
            this.playerRanks = new ArrayList<RPlayerRank>();
        }
        this.playerRanks.add(playerRank);
        playerRank.setRdqPlayer(this);
    }

    public Optional<RPlayerRank> getPlayerRankForTree(@NotNull String rankTreeIdentifier) {
        if (this.playerRanks == null) {
            return Optional.empty();
        }
        return this.playerRanks.stream().filter(rank -> rank.belongsToRankTree(rankTreeIdentifier)).findFirst();
    }

    public Optional<RPlayerRank> getActivePlayerRank() {
        if (this.playerRanks == null) {
            return Optional.empty();
        }
        return this.playerRanks.stream().filter(RPlayerRank::isActive).findFirst();
    }

    public boolean hasAnyRanks() {
        return this.playerRanks != null && !this.playerRanks.isEmpty();
    }

    public boolean hasRankInTree(@NotNull String rankTreeIdentifier) {
        return this.getPlayerRankForTree(rankTreeIdentifier).isPresent();
    }

    @Deprecated
    public RPlayerRank getPlayerRank() {
        if (this.playerRanks == null || this.playerRanks.isEmpty()) {
            return null;
        }
        return this.playerRanks.getFirst();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RDQPlayer)) {
            return false;
        }
        RDQPlayer rdqPlayer = (RDQPlayer)o;
        return this.uniqueId.equals(rdqPlayer.uniqueId);
    }

    @Override
    public int hashCode() {
        return this.uniqueId.hashCode();
    }
}

