/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.bounty;

import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.database.converter.IconSectionConverter;
import com.raindropcentral.rdq.database.converter.RewardConverter;
import com.raindropcentral.rdq.reward.AbstractReward;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="rdq_bounty_reward")
public class BountyReward
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="reward_data", nullable=false, columnDefinition="LONGTEXT")
    @Convert(converter=RewardConverter.class)
    private AbstractReward reward;
    @Convert(converter=IconSectionConverter.class)
    @Column(name="reward_icon", columnDefinition="LONGTEXT")
    private IconSection icon;
    @Column(name="contributor_unique_id")
    private UUID contributorUniqueId;
    @Column(name="estimated_value")
    private double estimatedValue;

    protected BountyReward() {
    }

    public BountyReward(@NotNull AbstractReward reward) {
        this.reward = reward;
        this.contributorUniqueId = null;
        this.icon = new IconSection(new EvaluationEnvironmentBuilder());
    }

    public BountyReward(@NotNull AbstractReward reward, @NotNull UUID contributorUniqueId) {
        this.reward = reward;
        this.contributorUniqueId = contributorUniqueId;
        this.icon = new IconSection(new EvaluationEnvironmentBuilder());
    }

    public BountyReward(@NotNull AbstractReward reward, @NotNull IconSection icon, @Nullable UUID contributorUniqueId) {
        this.reward = reward;
        this.icon = icon;
        this.contributorUniqueId = contributorUniqueId;
    }

    @NotNull
    public CompletableFuture<Boolean> grant(@NotNull Player player) {
        return this.reward.grant(player);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BountyReward)) {
            return false;
        }
        BountyReward other = (BountyReward)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public String toString() {
        return "BountyReward[id=%d, rewardData=%s]".formatted(this.getId(), this.reward.toString());
    }

    @Generated
    public AbstractReward getReward() {
        return this.reward;
    }

    @Generated
    public IconSection getIcon() {
        return this.icon;
    }

    @Generated
    public UUID getContributorUniqueId() {
        return this.contributorUniqueId;
    }

    @Generated
    public double getEstimatedValue() {
        return this.estimatedValue;
    }

    @Generated
    public void setReward(AbstractReward reward) {
        this.reward = reward;
    }

    @Generated
    public void setIcon(IconSection icon) {
        this.icon = icon;
    }

    @Generated
    public void setContributorUniqueId(UUID contributorUniqueId) {
        this.contributorUniqueId = contributorUniqueId;
    }

    @Generated
    public void setEstimatedValue(double estimatedValue) {
        this.estimatedValue = estimatedValue;
    }
}

