/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.bounty;

import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_bounty_hunter", uniqueConstraints={@UniqueConstraint(columnNames={"player_id"})}, indexes={@Index(name="idx_bounties_claimed", columnList="bounties_claimed DESC"), @Index(name="idx_total_reward_value", columnList="total_reward_value DESC")})
public class BountyHunter
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="player_id", nullable=false, unique=true)
    private RDQPlayer player;
    @Column(name="bounties_claimed", nullable=false)
    private int bountiesClaimed = 0;
    @Column(name="total_reward_value", nullable=false)
    private double totalRewardValue = 0.0;
    @Column(name="highest_bounty_value", nullable=false)
    private double highestBountyValue = 0.0;
    @Column(name="last_claim_timestamp")
    private Long lastClaimTimestamp;

    protected BountyHunter() {
    }

    public BountyHunter(@NotNull RDQPlayer player) {
        this.player = player;
    }

    public void recordClaim(double rewardValue) {
        this.incrementBountiesClaimed();
        this.addRewardValue(rewardValue);
    }

    public void incrementBountiesClaimed() {
        ++this.bountiesClaimed;
    }

    public void addRewardValue(double value) {
        if (value > 0.0) {
            this.totalRewardValue += value;
            if (value > this.highestBountyValue) {
                this.highestBountyValue = value;
            }
        }
    }

    @Generated
    public RDQPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public int getBountiesClaimed() {
        return this.bountiesClaimed;
    }

    @Generated
    public double getTotalRewardValue() {
        return this.totalRewardValue;
    }

    @Generated
    public double getHighestBountyValue() {
        return this.highestBountyValue;
    }

    @Generated
    public Long getLastClaimTimestamp() {
        return this.lastClaimTimestamp;
    }

    @Generated
    public void setPlayer(RDQPlayer player) {
        this.player = player;
    }

    @Generated
    public void setBountiesClaimed(int bountiesClaimed) {
        this.bountiesClaimed = bountiesClaimed;
    }

    @Generated
    public void setTotalRewardValue(double totalRewardValue) {
        this.totalRewardValue = totalRewardValue;
    }

    @Generated
    public void setHighestBountyValue(double highestBountyValue) {
        this.highestBountyValue = highestBountyValue;
    }

    @Generated
    public void setLastClaimTimestamp(Long lastClaimTimestamp) {
        this.lastClaimTimestamp = lastClaimTimestamp;
    }
}

