/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.bounty;

import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_bounty", indexes={@Index(name="idx_rbounty_target", columnList="target_unique_id"), @Index(name="idx_rbounty_commissioner", columnList="commissioner_unique_id"), @Index(name="idx_rbounty_active", columnList="active"), @Index(name="idx_rbounty_expires", columnList="expires_at")})
public class Bounty
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="target_unique_id", unique=true, nullable=false)
    private UUID targetUniqueId;
    @Column(name="commissioner_unique_id", nullable=false)
    private UUID commissionerUniqueId;
    @Column(name="expires_at")
    private LocalDateTime expiresAt;
    @Column(name="active", nullable=false)
    private boolean active = true;
    @Column(name="claimed_by")
    private UUID claimedBy;
    @Column(name="claimed_at")
    private LocalDateTime claimedAt;
    @Column(name="total_estimated_value", nullable=false)
    private double totalEstimatedValue;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @JoinColumn(name="bounty_id")
    private List<BountyReward> rewards = new ArrayList<BountyReward>();
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="r_reward_bounty_history", joinColumns={@JoinColumn(name="entry_id")})
    @Column(name="reward_history")
    private Set<String> rewardHistory = new HashSet<String>();

    protected Bounty() {
    }

    public Bounty(@NotNull UUID targetUniqueId, @NotNull UUID commissionerUniqueId) {
        this.targetUniqueId = targetUniqueId;
        this.commissionerUniqueId = commissionerUniqueId;
        this.expiresAt = null;
    }

    public Bounty(@NotNull UUID targetUniqueId, @NotNull UUID commissionerUniqueId, @NotNull List<BountyReward> rewards) {
        this(targetUniqueId, commissionerUniqueId);
        this.rewards = rewards;
    }

    public void addReward(@NotNull BountyReward rewardItem) {
        this.rewards.add(rewardItem);
    }

    public boolean isClaimed() {
        return this.claimedBy != null;
    }

    public boolean isExpired() {
        return this.expiresAt != null && LocalDateTime.now().isAfter(this.expiresAt);
    }

    public void claim(@NotNull UUID claimedBy) {
        this.claimedBy = claimedBy;
        this.claimedAt = LocalDateTime.now();
        this.active = false;
    }

    public void expire() {
        this.active = false;
    }

    @Generated
    public UUID getTargetUniqueId() {
        return this.targetUniqueId;
    }

    @Generated
    public UUID getCommissionerUniqueId() {
        return this.commissionerUniqueId;
    }

    @Generated
    public LocalDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public UUID getClaimedBy() {
        return this.claimedBy;
    }

    @Generated
    public LocalDateTime getClaimedAt() {
        return this.claimedAt;
    }

    @Generated
    public double getTotalEstimatedValue() {
        return this.totalEstimatedValue;
    }

    @Generated
    public List<BountyReward> getRewards() {
        return this.rewards;
    }

    @Generated
    public Set<String> getRewardHistory() {
        return this.rewardHistory;
    }

    @Generated
    public void setTargetUniqueId(UUID targetUniqueId) {
        this.targetUniqueId = targetUniqueId;
    }

    @Generated
    public void setCommissionerUniqueId(UUID commissionerUniqueId) {
        this.commissionerUniqueId = commissionerUniqueId;
    }

    @Generated
    public void setExpiresAt(LocalDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setClaimedBy(UUID claimedBy) {
        this.claimedBy = claimedBy;
    }

    @Generated
    public void setClaimedAt(LocalDateTime claimedAt) {
        this.claimedAt = claimedAt;
    }

    @Generated
    public void setTotalEstimatedValue(double totalEstimatedValue) {
        this.totalEstimatedValue = totalEstimatedValue;
    }

    @Generated
    public void setRewards(List<BountyReward> rewards) {
        this.rewards = rewards;
    }

    @Generated
    public void setRewardHistory(Set<String> rewardHistory) {
        this.rewardHistory = rewardHistory;
    }
}

