/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity;

import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.database.converter.IconSectionConverter;
import com.raindropcentral.rdq.database.converter.RequirementConverter;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_requirement")
public class RRequirement
extends BaseEntity {
    @Column(name="requirement_data", nullable=false, columnDefinition="LONGTEXT")
    @Convert(converter=RequirementConverter.class)
    private AbstractRequirement requirement;
    @Convert(converter=IconSectionConverter.class)
    @Column(name="requirement_icon", nullable=false, columnDefinition="LONGTEXT")
    private IconSection icon;

    protected RRequirement() {
    }

    public RRequirement(@NotNull AbstractRequirement requirement, @NotNull IconSection icon) {
        this.requirement = requirement;
        this.icon = icon;
    }

    public AbstractRequirement getRequirement() {
        return this.requirement;
    }

    public IconSection getShowcase() {
        return this.icon;
    }

    public boolean isMet(@NotNull Player player) {
        return this.requirement.isMet(player);
    }

    public double calculateProgress(@NotNull Player player) {
        return this.requirement.calculateProgress(player);
    }

    public void consume(@NotNull Player player) {
        this.requirement.consume(player);
    }
}

