/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.converter;

import com.raindropcentral.rdq.json.reward.RewardParser;
import com.raindropcentral.rdq.reward.AbstractReward;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(autoApply=true)
public class RewardConverter
implements AttributeConverter<AbstractReward, String> {
    private static final Logger logger = LoggerFactory.getLogger(RewardConverter.class);

    public String convertToDatabaseColumn(AbstractReward attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            return RewardParser.serialize(attribute);
        }
        catch (IOException e) {
            logger.error("Failed to serialize requirement: {}", (Object)attribute, (Object)e);
            throw new RuntimeException("Failed to serialize requirement", e);
        }
    }

    public AbstractReward convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return null;
        }
        try {
            return RewardParser.parse(dbData);
        }
        catch (IOException e) {
            logger.error("Failed to deserialize requirement from database string: {}", (Object)dbData, (Object)e);
            throw new RuntimeException("Failed to deserialize requirement", e);
        }
    }
}

