/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.converter;

import com.raindropcentral.rdq.json.requirement.RequirementParser;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(autoApply=true)
public class RequirementConverter
implements AttributeConverter<AbstractRequirement, String> {
    private static final Logger logger = LoggerFactory.getLogger(RequirementConverter.class);

    public String convertToDatabaseColumn(AbstractRequirement attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            return RequirementParser.serialize(attribute);
        }
        catch (IOException e) {
            logger.error("Failed to serialize requirement: {}", (Object)attribute, (Object)e);
            throw new RuntimeException("Failed to serialize requirement", e);
        }
    }

    public AbstractRequirement convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return null;
        }
        try {
            return RequirementParser.parse(dbData);
        }
        catch (IOException e) {
            logger.error("Failed to deserialize requirement from database string: {}", (Object)dbData, (Object)e);
            throw new RuntimeException("Failed to deserialize requirement", e);
        }
    }
}

