/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.converter;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.database.converter.ConverterTool;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public class IconSectionConverter
implements AttributeConverter<IconSection, String> {
    private static final Logger LOGGER = Logger.getLogger(IconSectionConverter.class.getName());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ConverterTool CONVERTER_TOOL = new ConverterTool();

    public String convertToDatabaseColumn(@Nullable IconSection iconSection) {
        if (iconSection == null) {
            return null;
        }
        try {
            IconSectionData data = new IconSectionData(iconSection.getMaterial(), iconSection.getDisplayNameKey(), iconSection.getDescriptionKey());
            return OBJECT_MAPPER.writeValueAsString((Object)data);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to convert IconSection to JSON", e);
            throw new RuntimeException("Failed to serialize IconSection", e);
        }
    }

    public IconSection convertToEntityAttribute(@Nullable String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return new IconSection(new EvaluationEnvironmentBuilder());
        }
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(jsonString);
            IconSectionData data = (IconSectionData)OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, IconSectionData.class);
            IconSection iconSection = new IconSection(new EvaluationEnvironmentBuilder());
            try {
                Material material = Material.valueOf((String)data.material);
                CONVERTER_TOOL.setPrivateField(iconSection, "type", data.material, LOGGER);
            }
            catch (Exception exception) {
                LOGGER.warning("Failed to convert IconSection to Material: " + exception.getMessage());
                CONVERTER_TOOL.setPrivateField(iconSection, "type", "BARRIER", LOGGER);
            }
            CONVERTER_TOOL.setPrivateField(iconSection, "displayNameKey", data.displayNameKey, LOGGER);
            CONVERTER_TOOL.setPrivateField(iconSection, "descriptionKey", data.descriptionKey, LOGGER);
            return iconSection;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to convert JSON to IconSection: " + jsonString, exception);
            throw new RuntimeException("Failed to deserialize IconSection", exception);
        }
    }

    private static class IconSectionData {
        public String material;
        public String displayNameKey;
        public String descriptionKey;

        public IconSectionData() {
        }

        public IconSectionData(@Nullable String material, @Nullable String displayNameKey, @Nullable String descriptionKey) {
            this.material = material;
            this.displayNameKey = displayNameKey;
            this.descriptionKey = descriptionKey;
        }
    }
}

