/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.config.utility;

import com.raindropcentral.rdq.config.utility.IconSection;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.evaluable.section.ItemStackSection;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class RequirementSection
extends AConfigSection {
    @CSAlways
    private String type;
    @CSAlways
    private IconSection icon;
    @CSAlways
    private String descriptionKey;
    private Integer displayOrder;
    private Boolean consumeOnComplete;
    private Map<String, ItemStackSection> requiredItems;
    private List<ItemStack> items;
    private ItemStackSection requiredItem;
    private Integer requiredAmount;
    private Map<String, Double> requiredCurrencies;
    private String currencyType;
    private Double currencyAmount;
    private String currency;
    private Double amount;
    private Integer requiredLevel;
    private Integer level;
    private String experienceType;
    private Long requiredPlaytimeSeconds;
    private Long playtimeSeconds;
    private Long requiredPlaytimeMinutes;
    private Long requiredPlaytimeHours;
    private String requiredAchievement;
    private String achievement;
    private List<String> requiredAchievements;
    private List<String> achievements;
    private String requiredPreviousRank;
    private String previousRank;
    private String requiredPreviousRankTree;
    private String previousRankTree;
    private List<String> requiredPreviousRanks;
    private String requiredSkill;
    private String skill;
    private Integer requiredSkillLevel;
    private Integer skillLevel;
    private Map<String, Integer> requiredSkills;
    private Map<String, Integer> skills;
    private String skillPlugin;
    private String requiredJob;
    private String job;
    private Integer requiredJobLevel;
    private Integer jobLevel;
    private Map<String, Integer> requiredJobs;
    private Map<String, Integer> jobs;
    private String jobPlugin;
    private Long timeConstraintSeconds;
    private Long timeConstraint;
    private Long cooldownSeconds;
    private Long cooldown;
    private String startTime;
    private String endTime;
    private String operator;
    private String compositeOperator;
    private List<RequirementSection> requirements;
    private Map<String, RequirementSection> subRequirements;
    private Integer minimumRequired;
    private List<RequirementSection> choices;
    private Map<String, RequirementSection> choiceMap;
    private List<RequirementSection> choiceList;
    private String description;
    private String choiceDescription;
    private String requiredPermission;
    private String permission;
    private List<String> requiredPermissions;
    private List<String> permissions;
    private String requiredWorld;
    private String world;
    private String requiredRegion;
    private String region;
    private Map<String, Double> requiredCoordinates;
    private Map<String, Double> coordinates;
    private Double requiredDistance;
    private Double distance;
    private Map<String, Object> data;
    private Map<String, Object> customData;
    private String customScript;

    public RequirementSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    public String getType() {
        return this.type != null ? this.type : "ITEM";
    }

    public IconSection getIcon() {
        return this.icon != null ? this.icon : new IconSection(new EvaluationEnvironmentBuilder());
    }

    public Integer getDisplayOrder() {
        return this.displayOrder != null ? this.displayOrder : 0;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public Boolean getConsumeOnComplete() {
        return this.consumeOnComplete != null ? this.consumeOnComplete : true;
    }

    public List<ItemStack> getRequiredItemsList() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (this.requiredItems != null) {
            itemList.addAll(this.requiredItems.values().stream().map(itemSection -> itemSection.asItem().build()).toList());
        }
        if (this.items != null) {
            itemList.addAll(this.items);
        }
        if (this.requiredItem != null) {
            ItemStack singleItem = this.requiredItem.asItem().build();
            if (this.requiredAmount != null && this.requiredAmount > 1) {
                singleItem.setAmount(this.requiredAmount.intValue());
            }
            itemList.add(singleItem);
        }
        return itemList;
    }

    public Map<String, Double> getRequiredCurrencies() {
        HashMap<String, Double> currencies = new HashMap<String, Double>();
        if (this.requiredCurrencies != null) {
            currencies.putAll(this.requiredCurrencies);
        }
        String currencyId = null;
        Double currencyAmount = null;
        if (this.currencyType != null && this.currencyAmount != null) {
            currencyId = this.currencyType;
            currencyAmount = this.currencyAmount;
        } else if (this.currency != null && this.amount != null) {
            currencyId = this.currency;
            currencyAmount = this.amount;
        }
        if (currencyId != null) {
            currencies.put(currencyId, currencyAmount);
        }
        return currencies;
    }

    public Integer getRequiredLevel() {
        if (this.requiredLevel != null) {
            return this.requiredLevel;
        }
        if (this.level != null) {
            return this.level;
        }
        return 1;
    }

    public String getExperienceType() {
        return this.experienceType != null ? this.experienceType : "LEVEL";
    }

    public Long getRequiredPlaytimeSeconds() {
        if (this.requiredPlaytimeSeconds != null) {
            return this.requiredPlaytimeSeconds;
        }
        if (this.playtimeSeconds != null) {
            return this.playtimeSeconds;
        }
        if (this.requiredPlaytimeMinutes != null) {
            return this.requiredPlaytimeMinutes * 60L;
        }
        if (this.requiredPlaytimeHours != null) {
            return this.requiredPlaytimeHours * 3600L;
        }
        return 0L;
    }

    public String getRequiredAchievement() {
        if (this.requiredAchievement != null) {
            return this.requiredAchievement;
        }
        if (this.achievement != null) {
            return this.achievement;
        }
        return "";
    }

    public List<String> getRequiredAchievements() {
        String singleAchievement;
        ArrayList<String> achievementList = new ArrayList<String>();
        if (this.requiredAchievements != null) {
            achievementList.addAll(this.requiredAchievements);
        }
        if (this.achievements != null) {
            achievementList.addAll(this.achievements);
        }
        if (!(singleAchievement = this.getRequiredAchievement()).isEmpty() && !achievementList.contains(singleAchievement)) {
            achievementList.add(singleAchievement);
        }
        return achievementList;
    }

    public String getRequiredPreviousRank() {
        if (this.requiredPreviousRank != null) {
            return this.requiredPreviousRank;
        }
        if (this.previousRank != null) {
            return this.previousRank;
        }
        return "";
    }

    public String getRequiredPreviousRankTree() {
        if (this.requiredPreviousRankTree != null) {
            return this.requiredPreviousRankTree;
        }
        if (this.previousRankTree != null) {
            return this.previousRankTree;
        }
        return "";
    }

    public List<String> getRequiredPreviousRanks() {
        String singleRank;
        ArrayList<String> ranks = new ArrayList<String>();
        if (this.requiredPreviousRanks != null) {
            ranks.addAll(this.requiredPreviousRanks);
        }
        if (!(singleRank = this.getRequiredPreviousRank()).isEmpty() && !ranks.contains(singleRank)) {
            ranks.add(singleRank);
        }
        return ranks;
    }

    public String getRequiredSkill() {
        if (this.requiredSkill != null) {
            return this.requiredSkill;
        }
        if (this.skill != null) {
            return this.skill;
        }
        return "";
    }

    public Integer getRequiredSkillLevel() {
        if (this.requiredSkillLevel != null) {
            return this.requiredSkillLevel;
        }
        if (this.skillLevel != null) {
            return this.skillLevel;
        }
        return 1;
    }

    public Map<String, Integer> getRequiredSkills() {
        String singleSkill;
        HashMap<String, Integer> skillMap = new HashMap<String, Integer>();
        if (this.requiredSkills != null) {
            skillMap.putAll(this.requiredSkills);
        }
        if (this.skills != null) {
            skillMap.putAll(this.skills);
        }
        if (!(singleSkill = this.getRequiredSkill()).isEmpty()) {
            skillMap.put(singleSkill, this.getRequiredSkillLevel());
        }
        return skillMap;
    }

    public String getSkillPlugin() {
        return this.skillPlugin != null ? this.skillPlugin : "";
    }

    public String getRequiredJob() {
        if (this.requiredJob != null) {
            return this.requiredJob;
        }
        if (this.job != null) {
            return this.job;
        }
        return "";
    }

    public Integer getRequiredJobLevel() {
        if (this.requiredJobLevel != null) {
            return this.requiredJobLevel;
        }
        if (this.jobLevel != null) {
            return this.jobLevel;
        }
        return 1;
    }

    public Map<String, Integer> getRequiredJobs() {
        String singleJob;
        HashMap<String, Integer> jobMap = new HashMap<String, Integer>();
        if (this.requiredJobs != null) {
            jobMap.putAll(this.requiredJobs);
        }
        if (this.jobs != null) {
            jobMap.putAll(this.jobs);
        }
        if (!(singleJob = this.getRequiredJob()).isEmpty()) {
            jobMap.put(singleJob, this.getRequiredJobLevel());
        }
        return jobMap;
    }

    public String getJobPlugin() {
        return this.jobPlugin != null ? this.jobPlugin : "";
    }

    public Long getTimeConstraintSeconds() {
        if (this.timeConstraintSeconds != null) {
            return this.timeConstraintSeconds;
        }
        if (this.timeConstraint != null) {
            return this.timeConstraint;
        }
        return 0L;
    }

    public Long getCooldownSeconds() {
        if (this.cooldownSeconds != null) {
            return this.cooldownSeconds;
        }
        if (this.cooldown != null) {
            return this.cooldown;
        }
        return 0L;
    }

    public String getStartTime() {
        return this.startTime == null ? LocalDateTime.now().toString() : this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getOperator() {
        if (this.operator != null) {
            return this.operator;
        }
        if (this.compositeOperator != null) {
            return this.compositeOperator;
        }
        return "AND";
    }

    public List<RequirementSection> getRequirements() {
        return this.requirements != null ? this.requirements : new ArrayList<RequirementSection>();
    }

    public Map<String, RequirementSection> getSubRequirements() {
        return this.subRequirements != null ? this.subRequirements : new HashMap<String, RequirementSection>();
    }

    public Integer getMinimumRequired() {
        return this.minimumRequired != null ? this.minimumRequired : 1;
    }

    public List<RequirementSection> getChoices() {
        ArrayList<RequirementSection> choicesList = new ArrayList<RequirementSection>();
        if (this.choices != null) {
            choicesList.addAll(this.choices);
        }
        if (this.choiceList != null) {
            choicesList.addAll(this.choiceList);
        }
        return choicesList;
    }

    public Map<String, RequirementSection> getChoiceMap() {
        return this.choiceMap != null ? this.choiceMap : new HashMap<String, RequirementSection>();
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.choiceDescription != null) {
            return this.choiceDescription;
        }
        return "";
    }

    public String getRequiredPermission() {
        if (this.requiredPermission != null) {
            return this.requiredPermission;
        }
        if (this.permission != null) {
            return this.permission;
        }
        return "";
    }

    public List<String> getRequiredPermissions() {
        String singlePermission;
        ArrayList<String> permissionList = new ArrayList<String>();
        if (this.requiredPermissions != null) {
            permissionList.addAll(this.requiredPermissions);
        }
        if (this.permissions != null) {
            permissionList.addAll(this.permissions);
        }
        if (!(singlePermission = this.getRequiredPermission()).isEmpty() && !permissionList.contains(singlePermission)) {
            permissionList.add(singlePermission);
        }
        return permissionList;
    }

    public String getRequiredWorld() {
        if (this.requiredWorld != null) {
            return this.requiredWorld;
        }
        if (this.world != null) {
            return this.world;
        }
        return "";
    }

    public String getRequiredRegion() {
        if (this.requiredRegion != null) {
            return this.requiredRegion;
        }
        if (this.region != null) {
            return this.region;
        }
        return "";
    }

    public Map<String, Double> getRequiredCoordinates() {
        if (this.requiredCoordinates != null) {
            return this.requiredCoordinates;
        }
        if (this.coordinates != null) {
            return this.coordinates;
        }
        return new HashMap<String, Double>();
    }

    public Double getRequiredDistance() {
        if (this.requiredDistance != null) {
            return this.requiredDistance;
        }
        if (this.distance != null) {
            return this.distance;
        }
        return 0.0;
    }

    public Map<String, Object> getData() {
        return this.data != null ? this.data : new HashMap<String, Object>();
    }

    public Map<String, Object> getCustomData() {
        return this.customData != null ? this.customData : new HashMap<String, Object>();
    }

    public String getCustomScript() {
        return this.customScript != null ? this.customScript : "";
    }
}

