/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.config.requirement;

import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CSAlways
public class PlaytimeRequirementSection
extends AConfigSection {
    private Long requiredPlaytimeSeconds;
    private Long requiredPlaytimeMinutes;
    private Long requiredPlaytimeHours;
    private Long requiredPlaytimeDays;
    private Long time;
    private String timeUnit;
    private Boolean useTotalPlaytime;
    private Map<String, Long> worldPlaytimeRequirements;
    private List<String> worlds;
    private Long worldPlaytimeSeconds;
    private Long worldPlaytimeMinutes;
    private Long worldPlaytimeHours;
    private Long worldPlaytimeDays;
    private String description;

    public PlaytimeRequirementSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    public Long getRequiredPlaytimeSeconds() {
        if (this.requiredPlaytimeSeconds != null) {
            return this.requiredPlaytimeSeconds;
        }
        if (this.requiredPlaytimeMinutes != null) {
            return TimeUnit.MINUTES.toSeconds(this.requiredPlaytimeMinutes);
        }
        if (this.requiredPlaytimeHours != null) {
            return TimeUnit.HOURS.toSeconds(this.requiredPlaytimeHours);
        }
        if (this.requiredPlaytimeDays != null) {
            return TimeUnit.DAYS.toSeconds(this.requiredPlaytimeDays);
        }
        if (this.time != null) {
            return this.convertTimeToSeconds(this.time, this.getTimeUnit());
        }
        return 0L;
    }

    public String getTimeUnit() {
        return this.timeUnit != null ? this.timeUnit.toLowerCase() : "seconds";
    }

    @Nullable
    public Boolean getUseTotalPlaytime() {
        if (this.useTotalPlaytime != null) {
            return this.useTotalPlaytime;
        }
        if (this.hasWorldSpecificConfiguration()) {
            return false;
        }
        return true;
    }

    @NotNull
    public Map<String, Long> getWorldPlaytimeRequirements() {
        Long worldPlaytime;
        HashMap<String, Long> requirements = new HashMap<String, Long>();
        if (this.worldPlaytimeRequirements != null) {
            requirements.putAll(this.worldPlaytimeRequirements);
        }
        if (this.worlds != null && !this.worlds.isEmpty() && (worldPlaytime = this.getWorldPlaytimeSeconds()) > 0L) {
            for (String world : this.worlds) {
                if (world == null || world.trim().isEmpty()) continue;
                requirements.put(world.trim(), worldPlaytime);
            }
        }
        return requirements;
    }

    public Long getWorldPlaytimeSeconds() {
        if (this.worldPlaytimeSeconds != null) {
            return this.worldPlaytimeSeconds;
        }
        if (this.worldPlaytimeMinutes != null) {
            return TimeUnit.MINUTES.toSeconds(this.worldPlaytimeMinutes);
        }
        if (this.worldPlaytimeHours != null) {
            return TimeUnit.HOURS.toSeconds(this.worldPlaytimeHours);
        }
        if (this.worldPlaytimeDays != null) {
            return TimeUnit.DAYS.toSeconds(this.worldPlaytimeDays);
        }
        return 0L;
    }

    @Nullable
    public List<String> getWorlds() {
        return this.worlds;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Long getTime() {
        return this.time;
    }

    public boolean hasWorldSpecificConfiguration() {
        return this.worldPlaytimeRequirements != null && !this.worldPlaytimeRequirements.isEmpty() || this.worlds != null && !this.worlds.isEmpty() && this.getWorldPlaytimeSeconds() > 0L;
    }

    public void validate() {
        if (this.getRequiredPlaytimeSeconds() <= 0L && !this.hasWorldSpecificConfiguration()) {
            throw new IllegalStateException("At least one playtime requirement must be specified");
        }
        if (this.getUseTotalPlaytime() == Boolean.FALSE && !this.hasWorldSpecificConfiguration()) {
            throw new IllegalStateException("useTotalPlaytime is false but no world-specific requirements are configured");
        }
        Map<String, Long> worldRequirements = this.getWorldPlaytimeRequirements();
        for (Map.Entry<String, Long> entry : worldRequirements.entrySet()) {
            if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                throw new IllegalStateException("World name cannot be null or empty");
            }
            if (entry.getValue() > 0L) continue;
            throw new IllegalStateException("World playtime requirement must be positive: " + String.valueOf(entry.getValue()));
        }
    }

    private Long convertTimeToSeconds(@NotNull Long timeValue, @NotNull String unit) {
        return switch (unit.toLowerCase()) {
            case "minutes", "minute", "min", "m" -> TimeUnit.MINUTES.toSeconds(timeValue);
            case "hours", "hour", "hr", "h" -> TimeUnit.HOURS.toSeconds(timeValue);
            case "days", "day", "d" -> TimeUnit.DAYS.toSeconds(timeValue);
            case "weeks", "week", "w" -> TimeUnit.DAYS.toSeconds(timeValue * 7L);
            default -> timeValue;
        };
    }
}

