/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.config.requirement;

import com.raindropcentral.rdq.config.requirement.BaseRequirementSection;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CSAlways
public class CompositeRequirementSection
extends AConfigSection {
    private String operator;
    private String compositeOperator;
    private List<BaseRequirementSection> requirements;
    private Map<String, BaseRequirementSection> subRequirements;
    private Integer minimumRequired;
    private Integer maximumRequired;
    private Boolean allowPartialProgress;
    private String description;

    public CompositeRequirementSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getAllowPartialProgress() {
        return this.allowPartialProgress != null ? this.allowPartialProgress : true;
    }

    public String getOperator() {
        if (this.operator != null) {
            return this.operator.toUpperCase();
        }
        if (this.compositeOperator != null) {
            return this.compositeOperator.toUpperCase();
        }
        return "AND";
    }

    public List<BaseRequirementSection> getCompositeRequirements() {
        ArrayList<BaseRequirementSection> requirementList = new ArrayList<BaseRequirementSection>();
        if (this.requirements != null) {
            requirementList.addAll(this.requirements);
        }
        if (this.subRequirements != null) {
            requirementList.addAll(this.subRequirements.values());
        }
        return requirementList;
    }

    public Map<String, BaseRequirementSection> getSubRequirements() {
        return this.subRequirements != null ? this.subRequirements : new HashMap<String, BaseRequirementSection>();
    }

    public Integer getMinimumRequired() {
        String op;
        if (this.minimumRequired != null) {
            return this.minimumRequired;
        }
        return switch (op = this.getOperator()) {
            case "OR", "XOR" -> 1;
            case "AND" -> this.getCompositeRequirements().size();
            default -> 1;
        };
    }

    public Integer getMaximumRequired() {
        String op;
        if (this.maximumRequired != null) {
            return this.maximumRequired;
        }
        return switch (op = this.getOperator()) {
            case "XOR" -> 1;
            default -> this.getCompositeRequirements().size();
        };
    }
}

