/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.config.requirement;

import com.raindropcentral.rdq.config.requirement.AchievementRequirementSection;
import com.raindropcentral.rdq.config.requirement.ChoiceRequirementSection;
import com.raindropcentral.rdq.config.requirement.CompositeRequirementSection;
import com.raindropcentral.rdq.config.requirement.CurrencyRequirementSection;
import com.raindropcentral.rdq.config.requirement.ExperienceLevelRequirementSection;
import com.raindropcentral.rdq.config.requirement.ItemRequirementSection;
import com.raindropcentral.rdq.config.requirement.JobRequirementSection;
import com.raindropcentral.rdq.config.requirement.LocationRequirementSection;
import com.raindropcentral.rdq.config.requirement.PermissionRequirementSection;
import com.raindropcentral.rdq.config.requirement.PlaytimeRequirementSection;
import com.raindropcentral.rdq.config.requirement.SkillRequirementSection;
import com.raindropcentral.rdq.config.requirement.TimeBasedRequirementSection;
import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.configmapper.sections.CSIgnore;
import de.jexcellence.evaluable.section.ItemStackSection;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

@CSAlways
public class BaseRequirementSection
extends AConfigSection {
    @CSIgnore
    private static final Logger LOGGER = CentralLogger.getLogger(BaseRequirementSection.class);
    private String type;
    private Integer displayOrder;
    private IconSection icon;
    private ItemRequirementSection itemRequirement;
    private CurrencyRequirementSection currencyRequirement;
    private ExperienceLevelRequirementSection experienceRequirement;
    private PlaytimeRequirementSection playtimeRequirement;
    private PermissionRequirementSection permissionRequirement;
    private LocationRequirementSection locationRequirement;
    private CompositeRequirementSection compositeRequirement;
    private ChoiceRequirementSection choiceRequirement;
    private AchievementRequirementSection achievementRequirement;
    private SkillRequirementSection skillRequirement;
    private JobRequirementSection jobRequirement;
    private TimeBasedRequirementSection timeBasedRequirement;
    private String operator;
    private List<BaseRequirementSection> requirements;
    private List<BaseRequirementSection> choices;
    private Integer minimumRequired;
    private Integer minimumChoicesRequired;
    private Integer maximumRequired;
    private Boolean allowPartialProgress;
    private Boolean mutuallyExclusive;
    private Boolean allowChoiceChange;
    private Integer level;
    private ItemStackSection requiredItem;
    @CSIgnore
    private String rankTreeName;
    @CSIgnore
    private String rankName;
    @CSIgnore
    private String requirementKey;

    public BaseRequirementSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    @Override
    public void afterParsing(List<Field> fields) throws Exception {
        super.afterParsing(fields);
        this.mapFlatStructureToNestedSections();
        if (this.type == null || this.type.equals("not_defined")) {
            this.type = this.autoDetectRequirementType();
        }
        if (this.icon != null && this.rankTreeName != null) {
            String baseKey = "requirement." + this.rankTreeName + "." + this.type.toLowerCase();
            if (this.icon.getDisplayNameKey() == null || this.icon.getDisplayNameKey().equals("not_defined")) {
                this.icon.setDisplayNameKey(baseKey + ".name");
            }
            if (this.icon.getDescriptionKey() == null || this.icon.getDescriptionKey().equals("not_defined")) {
                this.icon.setDescriptionKey(baseKey + ".lore");
            }
        }
    }

    private void mapFlatStructureToNestedSections() {
        if (this.type == null || this.type.equals("not_defined")) {
            return;
        }
        String upperType = this.type.toUpperCase();
        LOGGER.fine("Mapping flat structure for type: " + upperType);
        switch (upperType) {
            case "COMPOSITE": {
                this.mapToCompositeRequirement();
                break;
            }
            case "CHOICE": {
                this.mapToChoiceRequirement();
                break;
            }
            case "EXPERIENCE_LEVEL": {
                this.mapToExperienceRequirement();
                break;
            }
            case "ITEM": {
                this.mapToItemRequirement();
                break;
            }
            case "PLAYTIME": {
                this.mapToPlaytimeRequirement();
            }
        }
    }

    private void mapToCompositeRequirement() {
        if (this.compositeRequirement != null && this.compositeRequirement.getCompositeRequirements() != null && !this.compositeRequirement.getCompositeRequirements().isEmpty()) {
            return;
        }
        if (this.requirements == null || this.requirements.isEmpty()) {
            LOGGER.warning("COMPOSITE requirement has no sub-requirements");
            return;
        }
        CompositeRequirementSection composite = new CompositeRequirementSection(new EvaluationEnvironmentBuilder());
        try {
            this.setFieldValue(composite, "operator", this.operator);
            this.setFieldValue(composite, "requirements", this.requirements);
            this.setFieldValue(composite, "minimumRequired", this.minimumRequired);
            this.setFieldValue(composite, "maximumRequired", this.maximumRequired);
            this.setFieldValue(composite, "allowPartialProgress", this.allowPartialProgress);
            this.compositeRequirement = composite;
            LOGGER.info("Mapped flat COMPOSITE with " + this.requirements.size() + " sub-requirements, operator=" + this.operator);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to map flat COMPOSITE structure: " + e.getMessage());
        }
    }

    private void mapToChoiceRequirement() {
        List<BaseRequirementSection> choiceList;
        if (this.choiceRequirement != null && this.choiceRequirement.getChoices() != null && !this.choiceRequirement.getChoices().isEmpty()) {
            return;
        }
        List<BaseRequirementSection> list = choiceList = this.choices != null ? this.choices : this.requirements;
        if (choiceList == null || choiceList.isEmpty()) {
            LOGGER.warning("CHOICE requirement has no choices");
            return;
        }
        ChoiceRequirementSection choice = new ChoiceRequirementSection(new EvaluationEnvironmentBuilder());
        try {
            this.setFieldValue(choice, "choices", choiceList);
            Integer minReq = this.minimumChoicesRequired != null ? this.minimumChoicesRequired : this.minimumRequired;
            this.setFieldValue(choice, "minimumRequired", minReq);
            this.setFieldValue(choice, "maximumRequired", this.maximumRequired);
            this.setFieldValue(choice, "allowPartialProgress", this.allowPartialProgress);
            this.setFieldValue(choice, "mutuallyExclusive", this.mutuallyExclusive);
            this.setFieldValue(choice, "allowChoiceChange", this.allowChoiceChange);
            this.choiceRequirement = choice;
            LOGGER.info("Mapped flat CHOICE with " + choiceList.size() + " choices, minRequired=" + minReq);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to map flat CHOICE structure: " + e.getMessage());
        }
    }

    private void mapToExperienceRequirement() {
        if (this.experienceRequirement != null && this.experienceRequirement.getRequiredLevel() > 0) {
            return;
        }
        if (this.level == null || this.level <= 0) {
            LOGGER.warning("EXPERIENCE_LEVEL requirement has no level specified");
            return;
        }
        ExperienceLevelRequirementSection exp = new ExperienceLevelRequirementSection(new EvaluationEnvironmentBuilder());
        try {
            this.setFieldValue(exp, "requiredExperience", this.level);
            this.setFieldValue(exp, "requiredType", "LEVEL");
            this.experienceRequirement = exp;
            LOGGER.info("Mapped flat EXPERIENCE_LEVEL with level=" + this.level);
        }
        catch (Exception e) {
            LOGGER.warning("Failed to map flat EXPERIENCE_LEVEL structure: " + e.getMessage());
        }
    }

    private void mapToItemRequirement() {
        if (this.itemRequirement != null && this.itemRequirement.getRequiredItemsList() != null && !this.itemRequirement.getRequiredItemsList().isEmpty()) {
            return;
        }
        if (this.requiredItem == null) {
            LOGGER.warning("ITEM requirement has no requiredItem specified");
            return;
        }
        ItemRequirementSection item = new ItemRequirementSection(new EvaluationEnvironmentBuilder());
        try {
            HashMap<String, ItemStackSection> itemsMap = new HashMap<String, ItemStackSection>();
            itemsMap.put("item1", this.requiredItem);
            this.setFieldValue(item, "requiredItems", itemsMap);
            this.itemRequirement = item;
            LOGGER.info("Mapped flat ITEM with requiredItem");
        }
        catch (Exception e) {
            LOGGER.warning("Failed to map flat ITEM structure: " + e.getMessage());
        }
    }

    private void mapToPlaytimeRequirement() {
        if (this.playtimeRequirement != null && this.playtimeRequirement.getRequiredPlaytimeSeconds() > 0L) {
            return;
        }
    }

    private void setFieldValue(Object target, String fieldName, Object value) throws Exception {
        if (value == null) {
            return;
        }
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(target, value);
                return;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field " + fieldName + " not found in " + target.getClass().getName());
    }

    private String autoDetectRequirementType() {
        if (this.itemRequirement != null && !this.itemRequirement.getRequiredItemsList().isEmpty()) {
            return "ITEM";
        }
        if (this.currencyRequirement != null && this.currencyRequirement.getRequiredCurrencies() != null && !this.currencyRequirement.getRequiredCurrencies().isEmpty()) {
            return "CURRENCY";
        }
        if (this.experienceRequirement != null && this.experienceRequirement.getRequiredLevel() > 0) {
            return "EXPERIENCE_LEVEL";
        }
        if (this.playtimeRequirement != null && this.playtimeRequirement.getRequiredPlaytimeSeconds() > 0L) {
            return "PLAYTIME";
        }
        if (this.permissionRequirement != null && this.permissionRequirement.getRequiredPermissions() != null && !this.permissionRequirement.getRequiredPermissions().isEmpty()) {
            return "PERMISSION";
        }
        if (this.locationRequirement != null) {
            return "LOCATION";
        }
        if (this.compositeRequirement != null && this.compositeRequirement.getCompositeRequirements() != null && !this.compositeRequirement.getCompositeRequirements().isEmpty()) {
            return "COMPOSITE";
        }
        if (this.choiceRequirement != null && this.choiceRequirement.getChoices() != null && !this.choiceRequirement.getChoices().isEmpty()) {
            return "CHOICE";
        }
        if (this.achievementRequirement != null && this.achievementRequirement.getRequiredAchievements() != null && !this.achievementRequirement.getRequiredAchievements().isEmpty()) {
            return "ACHIEVEMENT";
        }
        if (this.skillRequirement != null && this.skillRequirement.getRequiredSkills() != null && !this.skillRequirement.getRequiredSkills().isEmpty()) {
            return "SKILLS";
        }
        if (this.jobRequirement != null && this.jobRequirement.getRequiredJobs() != null && !this.jobRequirement.getRequiredJobs().isEmpty()) {
            return "JOBS";
        }
        if (this.timeBasedRequirement != null && this.timeBasedRequirement.getTimeConstraintSeconds() > 0L) {
            return "TIME_BASED";
        }
        return "UNKNOWN";
    }

    public void setContext(String rankTreeName, String rankName, String requirementKey) {
        this.rankTreeName = rankTreeName;
        this.rankName = rankName;
        this.requirementKey = requirementKey;
    }

    public String getType() {
        return this.type == null ? "not_defined" : this.type;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder == null ? 0 : this.displayOrder;
    }

    public IconSection getIcon() {
        return this.icon == null ? new IconSection(new EvaluationEnvironmentBuilder()) : this.icon;
    }

    public ItemRequirementSection getItemRequirement() {
        return this.itemRequirement == null ? new ItemRequirementSection(new EvaluationEnvironmentBuilder()) : this.itemRequirement;
    }

    public CurrencyRequirementSection getCurrencyRequirement() {
        return this.currencyRequirement == null ? new CurrencyRequirementSection(new EvaluationEnvironmentBuilder()) : this.currencyRequirement;
    }

    public ExperienceLevelRequirementSection getExperienceRequirement() {
        return this.experienceRequirement == null ? new ExperienceLevelRequirementSection(new EvaluationEnvironmentBuilder()) : this.experienceRequirement;
    }

    public PlaytimeRequirementSection getPlaytimeRequirement() {
        return this.playtimeRequirement == null ? new PlaytimeRequirementSection(new EvaluationEnvironmentBuilder()) : this.playtimeRequirement;
    }

    public PermissionRequirementSection getPermissionRequirement() {
        return this.permissionRequirement == null ? new PermissionRequirementSection(new EvaluationEnvironmentBuilder()) : this.permissionRequirement;
    }

    public LocationRequirementSection getLocationRequirement() {
        return this.locationRequirement == null ? new LocationRequirementSection(new EvaluationEnvironmentBuilder()) : this.locationRequirement;
    }

    public CompositeRequirementSection getCompositeRequirement() {
        return this.compositeRequirement == null ? new CompositeRequirementSection(new EvaluationEnvironmentBuilder()) : this.compositeRequirement;
    }

    public ChoiceRequirementSection getChoiceRequirement() {
        return this.choiceRequirement == null ? new ChoiceRequirementSection(new EvaluationEnvironmentBuilder()) : this.choiceRequirement;
    }

    public AchievementRequirementSection getAchievementRequirement() {
        return this.achievementRequirement == null ? new AchievementRequirementSection(new EvaluationEnvironmentBuilder()) : this.achievementRequirement;
    }

    public SkillRequirementSection getSkillRequirement() {
        return this.skillRequirement == null ? new SkillRequirementSection(new EvaluationEnvironmentBuilder()) : this.skillRequirement;
    }

    public JobRequirementSection getJobRequirement() {
        return this.jobRequirement == null ? new JobRequirementSection(new EvaluationEnvironmentBuilder()) : this.jobRequirement;
    }

    public TimeBasedRequirementSection getTimeBasedRequirement() {
        return this.timeBasedRequirement == null ? new TimeBasedRequirementSection(new EvaluationEnvironmentBuilder()) : this.timeBasedRequirement;
    }

    public String getRankTreeName() {
        return this.rankTreeName;
    }

    public String getRankName() {
        return this.rankName;
    }

    public String getRequirementKey() {
        return this.requirementKey;
    }
}

