/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.config.ranks.ranktree;

import com.raindropcentral.rdq.config.ranks.rank.RankSection;
import com.raindropcentral.rdq.config.ranks.system.CrossTreeProgressionSection;
import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.configmapper.sections.CSIgnore;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

@CSAlways
public class RankTreeSection
extends AConfigSection {
    private String displayNameKey;
    private String descriptionKey;
    private Integer displayOrder;
    private Boolean isEnabled;
    private Boolean isFinalRankTree;
    private Boolean requiresAllRankTreesToBeDone;
    private Integer minimumRankTreesToBeDone;
    private IconSection icon;
    private List<String> prerequisiteRankTrees;
    private List<String> unlockedRankTrees;
    private List<String> connectedRankTrees;
    private List<Integer> switchableRankTiers;
    private CrossTreeProgressionSection crossTreeProgression;
    private Map<String, RankSection> ranks;
    @CSIgnore
    private String treeId;

    public RankTreeSection(EvaluationEnvironmentBuilder baseEnvironment) {
        super(baseEnvironment);
    }

    @Override
    public void afterParsing(List<Field> fields) throws Exception {
        super.afterParsing(fields);
        if (this.treeId != null) {
            if (this.displayNameKey == null) {
                this.displayNameKey = "tree." + this.treeId + ".name";
            }
            if (this.descriptionKey == null) {
                this.descriptionKey = "tree." + this.treeId + ".lore";
            }
            if (this.icon != null) {
                if (this.icon.getDisplayNameKey() == null || this.icon.getDisplayNameKey().equals("not_defined")) {
                    this.icon.setDisplayNameKey("tree." + this.treeId + ".name");
                }
                if (this.icon.getDescriptionKey() == null || this.icon.getDescriptionKey().equals("not_defined")) {
                    this.icon.setDescriptionKey("tree." + this.treeId + ".lore");
                }
            }
            if (this.ranks != null) {
                for (Map.Entry<String, RankSection> entry : this.ranks.entrySet()) {
                    String rankId = entry.getKey();
                    RankSection rankSection = entry.getValue();
                    rankSection.setRankTreeName(this.treeId);
                    rankSection.setRankName(rankId);
                    try {
                        rankSection.afterParsing(new ArrayList<Field>());
                    }
                    catch (Exception exception) {
                        CentralLogger.getLogger(RankTreeSection.class.getName()).log(Level.WARNING, "Failed to process rank " + rankId + " in tree " + this.treeId + ": ", exception);
                    }
                }
            }
        }
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey == null ? "not_defined" : this.displayNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey == null ? "not_defined" : this.descriptionKey;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder == null ? -1 : this.displayOrder;
    }

    public Boolean getEnabled() {
        return this.isEnabled != null && this.isEnabled != false;
    }

    public Boolean getFinalRankTree() {
        return this.isFinalRankTree != null && this.isFinalRankTree != false;
    }

    public Boolean getRequiresAllRankTreesToBeDone() {
        return this.requiresAllRankTreesToBeDone == null || this.requiresAllRankTreesToBeDone != false;
    }

    public Integer getMinimumRankTreesToBeDone() {
        return this.minimumRankTreesToBeDone == null ? 0 : this.minimumRankTreesToBeDone;
    }

    public IconSection getIcon() {
        return this.icon == null ? new IconSection(new EvaluationEnvironmentBuilder()) : this.icon;
    }

    public List<String> getPrerequisiteRankTrees() {
        return this.prerequisiteRankTrees == null ? new ArrayList() : this.prerequisiteRankTrees;
    }

    public void setMinimumRankTreesToBeDone(Integer minimumRankTreesToBeDone) {
        this.minimumRankTreesToBeDone = minimumRankTreesToBeDone;
    }

    public List<String> getUnlockedRankTrees() {
        return this.unlockedRankTrees == null ? new ArrayList() : this.unlockedRankTrees;
    }

    public List<String> getConnectedRankTrees() {
        return this.connectedRankTrees == null ? new ArrayList() : this.connectedRankTrees;
    }

    public List<Integer> getSwitchableRankTiers() {
        return this.switchableRankTiers == null ? new ArrayList() : this.switchableRankTiers;
    }

    public CrossTreeProgressionSection getCrossTreeProgression() {
        return this.crossTreeProgression == null ? new CrossTreeProgressionSection(new EvaluationEnvironmentBuilder()) : this.crossTreeProgression;
    }

    public Map<String, RankSection> getRanks() {
        return this.ranks == null ? new HashMap() : this.ranks;
    }
}

