/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.config.ranks.rank;

import com.raindropcentral.rdq.config.requirement.BaseRequirementSection;
import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.config.utility.RewardSection;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.configmapper.sections.CSIgnore;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@CSAlways
public class RankSection
extends AConfigSection {
    private String displayNameKey;
    private String descriptionKey;
    private String luckPermsGroup;
    private String prefixKey;
    private String suffixKey;
    private Integer tier;
    private Integer weight;
    private IconSection icon;
    private List<String> previousRanks;
    private List<String> nextRanks;
    private Map<String, BaseRequirementSection> requirements;
    private Map<String, RewardSection> rewards;
    private Boolean isInitialRank;
    private Boolean isFinalRank;
    private Boolean requiresAllRankTreesToBeDone;
    private Boolean isEnabled;
    private List<String> crossRankTreeConnections;
    @CSIgnore
    private String rankTreeName;
    @CSIgnore
    private String rankName;

    public RankSection(EvaluationEnvironmentBuilder evaluationEnvironmentBuilder) {
        super(evaluationEnvironmentBuilder);
    }

    @Override
    public void afterParsing(List<Field> fields) throws Exception {
        super.afterParsing(fields);
        if (this.rankTreeName != null && this.rankName != null) {
            if (this.displayNameKey == null) {
                this.displayNameKey = "rank." + this.rankTreeName + "." + this.rankName + ".name";
            }
            if (this.descriptionKey == null) {
                this.descriptionKey = "rank." + this.rankTreeName + "." + this.rankName + ".lore";
            }
            if (this.prefixKey == null) {
                this.prefixKey = "rank." + this.rankTreeName + "." + this.rankName + ".prefix";
            }
            if (this.suffixKey == null) {
                this.suffixKey = "rank." + this.rankTreeName + "." + this.rankName + ".suffix";
            }
        }
    }

    public String getDisplayNameKey() {
        return this.displayNameKey == null ? "not_defined" : this.displayNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey == null ? "not_defined" : this.descriptionKey;
    }

    public String getLuckPermsGroup() {
        return this.luckPermsGroup == null ? "not_defined" : this.luckPermsGroup;
    }

    public String getPrefixKey() {
        return this.prefixKey == null ? "" : this.prefixKey;
    }

    public String getSuffixKey() {
        return this.suffixKey == null ? "" : this.suffixKey;
    }

    public Integer getTier() {
        return this.tier == null ? 0 : this.tier;
    }

    public Integer getWeight() {
        return this.weight == null ? 0 : this.weight;
    }

    public IconSection getIcon() {
        return this.icon == null ? new IconSection(new EvaluationEnvironmentBuilder()) : this.icon;
    }

    public List<String> getPreviousRanks() {
        return this.previousRanks == null ? new ArrayList() : this.previousRanks;
    }

    public List<String> getNextRanks() {
        return this.nextRanks == null ? new ArrayList() : this.nextRanks;
    }

    public Map<String, BaseRequirementSection> getRequirements() {
        return this.requirements == null ? new HashMap() : this.requirements;
    }

    public Map<String, RewardSection> getRewards() {
        return this.rewards == null ? new HashMap() : this.rewards;
    }

    public Boolean getInitialRank() {
        return this.isInitialRank != null && this.getFinalRank() == false;
    }

    public Boolean getFinalRank() {
        return this.isFinalRank != null && this.isFinalRank != false;
    }

    public Boolean getRequiresAllRankTreesToBeDone() {
        return this.requiresAllRankTreesToBeDone != null && this.requiresAllRankTreesToBeDone != false;
    }

    public Boolean getEnabled() {
        return this.isEnabled != null && this.isEnabled != false;
    }

    public List<String> getCrossRankTreeConnections() {
        return this.crossRankTreeConnections == null ? new ArrayList() : this.crossRankTreeConnections;
    }

    public String getRankTreeName() {
        return this.rankTreeName == null ? "not_defined_" + String.valueOf(UUID.randomUUID()) : this.rankTreeName;
    }

    public void setRankTreeName(String rankTreeName) {
        this.rankTreeName = rankTreeName;
    }

    public String getRankName() {
        return this.rankName == null ? "not_defined_" + String.valueOf(UUID.randomUUID()) : this.rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
}

