/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.command.player.rq;

import com.raindropcentral.commands.PlayerCommand;
import com.raindropcentral.commands.utility.Command;
import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.command.player.rq.EPRQAction;
import com.raindropcentral.rdq.command.player.rq.EPRQPermission;
import com.raindropcentral.rdq.command.player.rq.PRQSection;
import com.raindropcentral.rdq.view.admin.AdminOverviewView;
import com.raindropcentral.rdq.view.bounty.BountyMainView;
import com.raindropcentral.rdq.view.ranks.RankMainView;
import de.jexcellence.jextranslate.i18n.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@Command
public class PRQ
extends PlayerCommand {
    private final RDQ rdq;

    public PRQ(@NotNull PRQSection commandSection, @NotNull RDQ rdq) {
        super(commandSection);
        this.rdq = rdq;
    }

    @Override
    protected void onPlayerInvocation(@NotNull Player player, @NotNull String label, @NotNull String[] args) {
        if (this.hasNoPermission(player, EPRQPermission.COMMAND)) {
            return;
        }
        EPRQAction action = this.enumParameterOrElse(args, 0, EPRQAction.class, EPRQAction.HELP);
        switch (action) {
            case ADMIN: {
                if (this.hasNoPermission(player, EPRQPermission.ADMIN)) {
                    return;
                }
                if (this.rdq.getLuckPermsService() == null) {
                    new I18n.Builder("rq.no_luckperms_installed", player).includePrefix().build().sendMessage();
                    return;
                }
                this.rdq.getViewFrame().open(AdminOverviewView.class, player, Map.of("plugin", this.rdq, "pluginName", args.length >= 1 ? this.stringParameter(args, 0) : ""));
                break;
            }
            case BOUNTY: {
                if (this.hasNoPermission(player, EPRQPermission.BOUNTY)) {
                    return;
                }
                this.rdq.getViewFrame().open(BountyMainView.class, player, Map.of("plugin", this.rdq));
                break;
            }
            case MAIN: {
                if (!this.hasNoPermission(player, EPRQPermission.MAIN)) break;
                return;
            }
            case QUESTS: {
                if (!this.hasNoPermission(player, EPRQPermission.QUESTS)) break;
                return;
            }
            case RANKS: {
                if (this.hasNoPermission(player, EPRQPermission.RANKS)) {
                    return;
                }
                this.rdq.getViewFrame().open(RankMainView.class, player, Map.of("plugin", this.rdq));
                break;
            }
            case PERKS: {
                if (!this.hasNoPermission(player, EPRQPermission.PERKS)) break;
                return;
            }
            default: {
                new I18n.Builder("rq.help", player).includePrefix().build().sendMessage();
            }
        }
    }

    @Override
    protected List<String> onPlayerTabCompletion(@NotNull Player player, @NotNull String label, @NotNull String[] args) {
        if (this.hasNoPermission(player, EPRQPermission.COMMAND)) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>(Arrays.stream(EPRQAction.values()).map(Enum::name).toList());
            return (List)StringUtil.copyPartialMatches((String)args[0].toLowerCase(), suggestions, new ArrayList());
        }
        return new ArrayList<String>();
    }
}

