/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.visual;

import com.raindropcentral.rdq.RDQ;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class VisualIndicatorManager {
    private static final Logger LOGGER = Logger.getLogger(VisualIndicatorManager.class.getName());
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final RDQ rdq;
    private final String tabPrefix;
    private final String nameColor;
    private final boolean particlesEnabled;
    private final Particle particleType;
    private final int particleIntervalTicks;
    private final Map<UUID, PlayerIndicatorState> activeIndicators = new ConcurrentHashMap<UUID, PlayerIndicatorState>();

    public VisualIndicatorManager(@NotNull RDQ rdq) {
        this(rdq, "<gradient:#ff6b6b:#ff8e8e>\ud83d\udc80 BOUNTY </gradient>", "<gradient:#ff4444:#ff6666>", true, Particle.FLAME, 30);
    }

    public VisualIndicatorManager(@NotNull RDQ rdq, @NotNull String tabPrefix, @NotNull String nameColor, boolean particlesEnabled, @NotNull Particle particleType, int particleIntervalTicks) {
        this.rdq = rdq;
        this.tabPrefix = tabPrefix;
        this.nameColor = nameColor;
        this.particlesEnabled = particlesEnabled;
        this.particleType = particleType;
        this.particleIntervalTicks = particleIntervalTicks;
        if (particlesEnabled) {
            this.startParticleTask();
        }
        this.startPeriodicRefreshTask();
        LOGGER.info("VisualIndicatorManager initialized with particles: " + particlesEnabled);
    }

    public void applyIndicators(@NotNull Player player) {
        UUID playerId = player.getUniqueId();
        if (this.activeIndicators.containsKey(playerId)) {
            LOGGER.fine("Refreshing existing indicators for " + player.getName());
            this.removeIndicators(player);
        }
        try {
            Component originalDisplayName = player.displayName();
            Component originalTabListName = player.playerListName();
            Component prefixComponent = MINI_MESSAGE.deserialize((Object)this.tabPrefix);
            TextComponent playerNameComponent = Component.text((String)player.getName());
            Component newTabListName = prefixComponent.append((Component)playerNameComponent);
            player.playerListName(newTabListName);
            String coloredNameString = this.nameColor + player.getName();
            Component coloredName = MINI_MESSAGE.deserialize((Object)coloredNameString);
            player.displayName(coloredName);
            PlayerIndicatorState state = new PlayerIndicatorState(originalDisplayName, originalTabListName, System.currentTimeMillis());
            this.activeIndicators.put(playerId, state);
            LOGGER.info("Applied visual indicators to " + player.getName() + " (bounty target)");
            LOGGER.info("  - Original display name: " + String.valueOf(originalDisplayName));
            LOGGER.info("  - New display name: " + String.valueOf(coloredName));
            LOGGER.info("  - Original tab name: " + String.valueOf(originalTabListName));
            LOGGER.info("  - New tab name: " + String.valueOf(newTabListName));
            LOGGER.info("  - Active indicators count: " + this.activeIndicators.size());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to apply visual indicators to " + player.getName(), e);
        }
    }

    public void removeIndicators(@NotNull Player player) {
        UUID playerId = player.getUniqueId();
        PlayerIndicatorState state = this.activeIndicators.remove(playerId);
        if (state == null) {
            LOGGER.fine("No indicators to remove for " + player.getName());
            return;
        }
        try {
            player.displayName(state.originalDisplayName());
            player.playerListName(state.originalTabListName());
            LOGGER.info("Removed visual indicators from " + player.getName());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to remove visual indicators from " + player.getName(), e);
        }
    }

    public void removeIndicators(@NotNull UUID playerId) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null && player.isOnline()) {
            this.removeIndicators(player);
        } else {
            PlayerIndicatorState removed = this.activeIndicators.remove(playerId);
            if (removed != null) {
                LOGGER.fine("Removed indicator tracking for offline player " + String.valueOf(playerId));
            }
        }
    }

    public boolean hasIndicators(@NotNull UUID playerId) {
        return this.activeIndicators.containsKey(playerId);
    }

    private void startParticleTask() {
        this.rdq.getPlatform().getScheduler().runRepeating(this::spawnParticles, this.particleIntervalTicks, this.particleIntervalTicks);
        LOGGER.info("Started particle task with interval " + this.particleIntervalTicks + " ticks");
    }

    private void startPeriodicRefreshTask() {
        this.rdq.getPlatform().getScheduler().runRepeating(this::refreshIndicatorsForOnlinePlayers, 600L, 600L);
        LOGGER.info("Started periodic refresh task with 30 second interval");
    }

    private void refreshIndicatorsForOnlinePlayers() {
        int refreshCount = 0;
        for (UUID playerId : this.activeIndicators.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            try {
                String currentDisplayName;
                PlayerIndicatorState state = this.activeIndicators.get(playerId);
                if (state == null || (currentDisplayName = player.displayName().toString()).contains("BOUNTY") || currentDisplayName.contains("\ud83d\udc80")) continue;
                LOGGER.fine("Refreshing lost visual indicators for " + player.getName());
                this.applyIndicators(player);
                ++refreshCount;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to refresh indicators for " + player.getName(), e);
            }
        }
        if (refreshCount > 0) {
            LOGGER.info("Refreshed visual indicators for " + refreshCount + " players during periodic check");
        }
    }

    private void spawnParticles() {
        if (!this.particlesEnabled) {
            return;
        }
        int particleCount = 0;
        for (UUID playerId : this.activeIndicators.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            ++particleCount;
            try {
                Location loc = player.getLocation().add(0.0, 2.0, 0.0);
                player.getWorld().spawnParticle(this.particleType, loc, 12, 0.5, 0.8, 0.5, 0.03);
                player.getWorld().spawnParticle(Particle.SMOKE, loc.add(0.0, 0.5, 0.0), 4, 0.3, 0.3, 0.3, 0.01);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to spawn particles for " + player.getName(), e);
            }
        }
        if (particleCount > 0 && System.currentTimeMillis() % 10000L < (long)(this.particleIntervalTicks * 50)) {
            LOGGER.fine("Spawned particles for " + particleCount + " players with active bounties");
        }
    }

    public void shutdown() {
        for (UUID playerId : this.activeIndicators.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            this.removeIndicators(player);
        }
        this.activeIndicators.clear();
        LOGGER.info("VisualIndicatorManager shut down");
    }

    public int getActiveIndicatorCount() {
        return this.activeIndicators.size();
    }

    public void refreshAllIndicators() {
        for (UUID playerId : this.activeIndicators.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            this.removeIndicators(player);
            this.applyIndicators(player);
        }
        LOGGER.info("Refreshed visual indicators for " + this.activeIndicators.size() + " players");
    }

    public void forceRefreshIndicators(@NotNull Player player) {
        UUID playerId = player.getUniqueId();
        if (this.activeIndicators.containsKey(playerId)) {
            this.removeIndicators(player);
        }
        this.applyIndicators(player);
        this.updatePlayerDisplay(player);
        LOGGER.info("Force refreshed visual indicators for " + player.getName());
    }

    public void updatePlayerDisplay(@NotNull Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.activeIndicators.containsKey(playerId)) {
            return;
        }
        try {
            this.rdq.getPlatform().getScheduler().runSync(() -> {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.hidePlayer((Plugin)this.rdq.getPlugin(), player);
                    onlinePlayer.showPlayer((Plugin)this.rdq.getPlugin(), player);
                }
                LOGGER.fine("Forced display update for " + player.getName());
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to update player display for " + player.getName(), e);
        }
    }

    public void handleBountyExpiration(@NotNull UUID targetPlayerId) {
        this.removeIndicators(targetPlayerId);
        LOGGER.info("Removed visual indicators for expired bounty on player: " + String.valueOf(targetPlayerId));
    }

    private record PlayerIndicatorState(Component originalDisplayName, Component originalTabListName, long appliedTimestamp) {
    }
}

