/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.utility;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.bounty.DamageTracker;
import com.raindropcentral.rdq.bounty.IBountyService;
import com.raindropcentral.rdq.bounty.claim.ClaimHandler;
import com.raindropcentral.rdq.bounty.claim.ClaimResult;
import com.raindropcentral.rdq.bounty.config.BountySection;
import com.raindropcentral.rdq.bounty.distribution.RewardDistributor;
import com.raindropcentral.rdq.bounty.distribution.RewardDistributorFactory;
import com.raindropcentral.rdq.bounty.type.EClaimMode;
import com.raindropcentral.rdq.bounty.type.EDistributionMode;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.evaluable.ConfigKeeper;
import de.jexcellence.evaluable.ConfigManager;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyFactory {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private static final String FOLDER_PATH = "bounty";
    private static final String FILE_NAME = "bounty.yml";
    private final Map<UUID, Bounty> bountyCache = new ConcurrentHashMap<UUID, Bounty>();
    private final IBountyService bountyService;
    private final DamageTracker damageTracker;
    private final ClaimHandler claimHandler;
    private final RDQ rdq;
    private BountySection bountyConfiguration;
    private EClaimMode claimMode;
    private EDistributionMode distributionMode;

    public BountyFactory(@NotNull RDQ rdq, @NotNull IBountyService bountyService) {
        this.rdq = rdq;
        this.bountyService = bountyService;
        String serviceType = bountyService.isPremium() ? "Premium" : "Free";
        LOGGER.log(Level.INFO, "BountyFactory initialized with " + serviceType + " service");
        LOGGER.log(Level.INFO, "Max bounties per commissioner: " + bountyService.getMaxBountiesPerCommissioner());
        LOGGER.log(Level.INFO, "Max rewards per bounty: " + bountyService.getMaxBountyRewardsPerTarget());
        try {
            ConfigManager cfgManager = new ConfigManager((Plugin)this.rdq.getPlugin(), FOLDER_PATH);
            ConfigKeeper<BountySection> cfgKeeper = new ConfigKeeper<BountySection>(cfgManager, FILE_NAME, BountySection.class);
            this.bountyConfiguration = (BountySection)cfgKeeper.rootSection;
            LOGGER.log(Level.INFO, "Bounty configuration loaded successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to load bounty configuration, using defaults", exception);
            this.bountyConfiguration = new BountySection(new EvaluationEnvironmentBuilder());
        }
        this.claimMode = this.bountyConfiguration.getClaimMode();
        this.distributionMode = this.bountyConfiguration.getDefaultDistributionMode();
        this.damageTracker = new DamageTracker(this.bountyConfiguration.getTrackingWindowInMs());
        boolean selfClaimAllowed = this.bountyConfiguration.getSelfClaimAllowed();
        LOGGER.info("BountyFactory: selfClaimAllowed from config = " + selfClaimAllowed);
        LOGGER.info("BountyFactory: trackingWindowInMs = " + this.bountyConfiguration.getTrackingWindowInMs());
        LOGGER.info("BountyFactory: claimMode = " + String.valueOf((Object)this.bountyConfiguration.getClaimMode()));
        this.claimHandler = new ClaimHandler(this.damageTracker, this.claimMode, selfClaimAllowed);
        this.loadActiveBounties();
    }

    private void loadActiveBounties() {
        ((CompletableFuture)this.bountyService.findAll(0, 1000).thenAccept(bounties -> {
            for (Bounty bounty : bounties) {
                if (!bounty.isActive()) continue;
                this.bountyCache.put(bounty.getTargetUniqueId(), bounty);
            }
            LOGGER.log(Level.INFO, "Loaded " + this.bountyCache.size() + " active bounties into cache");
        })).exceptionally(throwable -> {
            LOGGER.log(Level.SEVERE, "Failed to load active bounties", (Throwable)throwable);
            return null;
        });
    }

    public CompletableFuture<Bounty> createBounty(@NotNull UUID targetUniqueId, @NotNull UUID commissionerUniqueId) {
        return this.bountyService.create(targetUniqueId, commissionerUniqueId).thenApply(bounty -> {
            this.bountyCache.put(targetUniqueId, (Bounty)bounty);
            LOGGER.log(Level.INFO, "Created bounty for " + String.valueOf(targetUniqueId) + " by " + String.valueOf(commissionerUniqueId));
            return bounty;
        });
    }

    public CompletableFuture<Bounty> createBounty(@NotNull UUID targetUniqueId, @NotNull UUID commissionerUniqueId, @NotNull List<BountyReward> rewards) {
        return this.bountyService.create(targetUniqueId, commissionerUniqueId, rewards).thenApply(bounty -> {
            this.bountyCache.put(targetUniqueId, (Bounty)bounty);
            LOGGER.log(Level.INFO, "Created bounty with " + rewards.size() + " rewards for " + String.valueOf(targetUniqueId));
            return bounty;
        });
    }

    public CompletableFuture<Bounty> updateBounty(@NotNull Bounty bounty) {
        LOGGER.log(Level.INFO, "Updating bounty for " + String.valueOf(bounty.getTargetUniqueId()) + " with " + bounty.getRewards().size() + " rewards");
        return ((CompletableFuture)this.bountyService.update(bounty).thenApply(updated -> {
            this.bountyCache.put(updated.getTargetUniqueId(), (Bounty)updated);
            LOGGER.log(Level.INFO, "Successfully updated bounty for " + String.valueOf(updated.getTargetUniqueId()) + " - cache updated");
            return updated;
        })).exceptionally(throwable -> {
            LOGGER.log(Level.SEVERE, "Failed to update bounty for " + String.valueOf(bounty.getTargetUniqueId()), (Throwable)throwable);
            throw new RuntimeException("Bounty update failed", (Throwable)throwable);
        });
    }

    public CompletableFuture<Bounty> addRewardsToBounty(@NotNull UUID targetUniqueId, @NotNull List<BountyReward> newRewards) {
        LOGGER.log(Level.INFO, "Adding " + newRewards.size() + " rewards to bounty for target: " + String.valueOf(targetUniqueId));
        return ((CompletableFuture)((CompletableFuture)this.bountyService.findPlayerBounty(targetUniqueId).thenCompose(bounty -> {
            if (bounty == null) {
                throw new RuntimeException("Bounty not found for target: " + String.valueOf(targetUniqueId));
            }
            for (BountyReward newReward : newRewards) {
                boolean merged = false;
                for (BountyReward existingReward : bounty.getRewards()) {
                    if (!this.canMergeRewards(existingReward, newReward)) continue;
                    this.mergeRewards(existingReward, newReward);
                    merged = true;
                    LOGGER.info("Merged reward from contributor " + String.valueOf(newReward.getContributorUniqueId()));
                    break;
                }
                if (merged) continue;
                BountyReward freshReward = new BountyReward(newReward.getReward(), newReward.getIcon(), newReward.getContributorUniqueId());
                freshReward.setEstimatedValue(newReward.getEstimatedValue());
                bounty.getRewards().add(freshReward);
                LOGGER.info("Added new reward from contributor " + String.valueOf(newReward.getContributorUniqueId()));
            }
            LOGGER.log(Level.INFO, "Bounty now has " + bounty.getRewards().size() + " total rewards");
            return this.bountyService.update((Bounty)bounty);
        })).thenApply(updated -> {
            this.bountyCache.put(updated.getTargetUniqueId(), (Bounty)updated);
            LOGGER.log(Level.INFO, "Successfully added rewards to bounty for " + String.valueOf(updated.getTargetUniqueId()) + " - cache updated");
            return updated;
        })).exceptionally(throwable -> {
            LOGGER.log(Level.SEVERE, "Failed to add rewards to bounty for target: " + String.valueOf(targetUniqueId), (Throwable)throwable);
            throw new RuntimeException("Failed to add rewards to bounty", (Throwable)throwable);
        });
    }

    public CompletableFuture<Bounty> deleteBounty(@NotNull Bounty bounty) {
        return this.bountyService.delete(bounty).thenApply(deleted -> {
            if (deleted.booleanValue()) {
                this.bountyCache.remove(bounty.getTargetUniqueId());
                LOGGER.log(Level.INFO, "Deleted bounty for " + String.valueOf(bounty.getTargetUniqueId()));
                return bounty;
            }
            return null;
        });
    }

    @Nullable
    public Bounty getBounty(@NotNull UUID uniqueId) {
        return this.bountyCache.get(uniqueId);
    }

    public CompletableFuture<Bounty> getBountyAsync(@NotNull UUID uniqueId) {
        Bounty cached = this.bountyCache.get(uniqueId);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return this.bountyService.findPlayerBounty(uniqueId).thenApply(bounty -> {
            if (bounty != null && bounty.isActive()) {
                this.bountyCache.put(uniqueId, (Bounty)bounty);
            }
            return bounty;
        });
    }

    public boolean hasBounty(@NotNull UUID uniqueId) {
        return this.bountyCache.containsKey(uniqueId);
    }

    public boolean canCreateBounty(@NotNull Player player) {
        return this.bountyService.canCreateBounty(player);
    }

    public CompletableFuture<List<Bounty>> getBountiesByCommissioner(@NotNull UUID commissionerUniqueId) {
        return this.bountyService.findBountiesByCommissioner(commissionerUniqueId);
    }

    public CompletableFuture<Integer> getTotalBounties() {
        return this.bountyService.getTotalBounties();
    }

    @NotNull
    public IBountyService getBountyService() {
        return this.bountyService;
    }

    @NotNull
    public DamageTracker getDamageTracker() {
        return this.damageTracker;
    }

    @NotNull
    public BountySection getBountyConfiguration() {
        return this.bountyConfiguration;
    }

    @NotNull
    public EClaimMode getClaimMode() {
        return this.claimMode;
    }

    public boolean isPremium() {
        return this.bountyService.isPremium();
    }

    public int getMaxBountiesPerCommissioner() {
        return this.bountyService.getMaxBountiesPerCommissioner();
    }

    public int getMaxRewardsPerBounty() {
        return this.bountyService.getMaxBountyRewardsPerTarget();
    }

    public CompletableFuture<ClaimResult> claimBounty(@NotNull UUID victimUuid, @Nullable UUID lastHitterUuid, @NotNull Location deathLocation) {
        LOGGER.info("ClaimBounty called for victim: " + String.valueOf(victimUuid) + ", lastHitter: " + String.valueOf(lastHitterUuid));
        return this.getBountyAsync(victimUuid).thenCompose(bounty -> {
            LOGGER.info("Bounty lookup result: " + (String)(bounty != null ? "found (active: " + bounty.isActive() + ")" : "null"));
            if (bounty == null || !bounty.isActive()) {
                LOGGER.info("No active bounty found, returning empty result");
                return CompletableFuture.completedFuture(ClaimResult.empty());
            }
            Map<UUID, Double> damageData = this.damageTracker.getDamageMap(victimUuid);
            LOGGER.info("DamageTracker has " + damageData.size() + " damage entries for victim");
            if (!damageData.isEmpty()) {
                LOGGER.info("Damage data: " + String.valueOf(damageData));
            }
            LOGGER.info("About to call ClaimHandler.determineClaim...");
            ClaimResult claimResult = this.claimHandler.determineClaim(victimUuid, lastHitterUuid);
            LOGGER.info("ClaimHandler.determineClaim returned");
            LOGGER.info("Claim result: " + claimResult.getWinnerCount() + " winners");
            if (!claimResult.hasWinners()) {
                LOGGER.info("No winners determined, clearing damage and returning empty result");
                this.claimHandler.clearDamage(victimUuid);
                return CompletableFuture.completedFuture(ClaimResult.empty());
            }
            bounty.claim(claimResult.winners().keySet().iterator().next());
            RewardDistributor distributor = RewardDistributorFactory.create(this.distributionMode);
            List<CompletableFuture> distributionFutures = claimResult.winners().entrySet().stream().map(entry -> {
                UUID winnerUuid = (UUID)entry.getKey();
                double proportion = (Double)entry.getValue();
                Player winner = Bukkit.getPlayer((UUID)winnerUuid);
                if (winner != null && winner.isOnline()) {
                    return distributor.distributeRewards(winner, (Bounty)bounty, deathLocation, proportion);
                }
                return CompletableFuture.completedFuture(null);
            }).toList();
            return ((CompletableFuture)CompletableFuture.allOf(distributionFutures.toArray(new CompletableFuture[0])).thenCompose(v -> this.bountyService.update((Bounty)bounty))).thenApply(updated -> {
                this.bountyCache.remove(victimUuid);
                this.claimHandler.clearDamage(victimUuid);
                LOGGER.log(Level.INFO, "Bounty claimed on " + String.valueOf(victimUuid) + " by " + claimResult.getWinnerCount() + " hunter(s)");
                return claimResult;
            });
        });
    }

    @NotNull
    public ClaimHandler getClaimHandler() {
        return this.claimHandler;
    }

    @NotNull
    public EDistributionMode getDistributionMode() {
        return this.distributionMode;
    }

    public void refreshCache() {
        this.bountyCache.clear();
        this.loadActiveBounties();
    }

    private boolean canMergeRewards(BountyReward existing, BountyReward newReward) {
        if (!Objects.equals(existing.getContributorUniqueId(), newReward.getContributorUniqueId())) {
            return false;
        }
        if (!existing.getReward().getType().equals((Object)newReward.getReward().getType())) {
            return false;
        }
        if (existing.getReward().getType() == Reward.Type.ITEM) {
            ItemReward existingItem = (ItemReward)existing.getReward();
            ItemReward newItem = (ItemReward)newReward.getReward();
            if (!existingItem.getItem().isSimilar(newItem.getItem())) {
                return false;
            }
            int maxStackSize = existingItem.getItem().getMaxStackSize();
            if (maxStackSize <= 1) {
                LOGGER.info("Cannot merge items with max stack size " + maxStackSize + " - creating separate entries");
                return false;
            }
            return true;
        }
        return true;
    }

    private void mergeRewards(BountyReward existing, BountyReward newReward) {
        if (existing.getReward().getType() == Reward.Type.ITEM) {
            ItemReward existingItem = (ItemReward)existing.getReward();
            ItemReward newItem = (ItemReward)newReward.getReward();
            int existingAmount = existingItem.getAmount();
            int newAmount = newItem.getAmount();
            int totalAmount = existingAmount + newAmount;
            LOGGER.info("Merging items: " + existingAmount + " (existing) + " + newAmount + " (new) = " + totalAmount + " (total)");
            existingItem.setAmount(totalAmount);
            LOGGER.info("Final merged amount: " + existingItem.getAmount());
        } else {
            existing.setEstimatedValue(existing.getEstimatedValue() + newReward.getEstimatedValue());
        }
    }
}

