/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.distribution;

import com.raindropcentral.rdq.bounty.distribution.RewardDistributor;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VirtualRewardDistributor
implements RewardDistributor {
    private static final Logger LOGGER = Logger.getLogger(VirtualRewardDistributor.class.getName());

    @Override
    @NotNull
    public CompletableFuture<Void> distributeRewards(@NotNull Player hunter, @NotNull Bounty bounty, @NotNull Location location, double proportion) {
        return CompletableFuture.runAsync(() -> {
            this.storeItemsVirtually(hunter, bounty, proportion);
            LOGGER.log(Level.INFO, "Stored bounty rewards virtually for " + hunter.getName());
        });
    }

    private void storeItemsVirtually(@NotNull Player hunter, @NotNull Bounty bounty, double proportion) {
        for (BountyReward reward : bounty.getRewards()) {
            if (reward.getReward().getType() != Reward.Type.ITEM) continue;
            ItemReward itemReward = (ItemReward)reward.getReward();
            ItemStack item = itemReward.getItem().clone();
            int adjustedAmount = Math.max(1, (int)((double)item.getAmount() * proportion));
            LOGGER.log(Level.INFO, String.format("Would store virtually: %s x%d for %s (%.1f%% share)", item.getType().name(), adjustedAmount, hunter.getName(), proportion * 100.0));
        }
    }
}

