/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.distribution;

import com.raindropcentral.rdq.bounty.distribution.RewardDistributor;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class InstantRewardDistributor
implements RewardDistributor {
    private static final Logger LOGGER = Logger.getLogger(InstantRewardDistributor.class.getName());

    @Override
    @NotNull
    public CompletableFuture<Void> distributeRewards(@NotNull Player hunter, @NotNull Bounty bounty, @NotNull Location location, double proportion) {
        return CompletableFuture.runAsync(() -> {
            this.distributeItems(hunter, bounty, proportion);
            LOGGER.log(Level.INFO, "Distributed " + proportion * 100.0 + "% of bounty rewards to " + hunter.getName());
        });
    }

    private void distributeItems(@NotNull Player hunter, @NotNull Bounty bounty, double proportion) {
        PlayerInventory inventory = hunter.getInventory();
        ArrayList excessItems = new ArrayList();
        for (BountyReward reward : bounty.getRewards()) {
            if (reward.getReward().getType() != Reward.Type.ITEM) continue;
            ItemReward itemReward = (ItemReward)reward.getReward();
            ItemStack item = itemReward.getItem().clone();
            int adjustedAmount = Math.max(1, (int)((double)item.getAmount() * proportion));
            item.setAmount(adjustedAmount);
            HashMap leftover = inventory.addItem(new ItemStack[]{item});
            if (leftover.isEmpty()) continue;
            excessItems.addAll(leftover.values());
        }
        if (!excessItems.isEmpty()) {
            Location dropLocation = hunter.getLocation();
            for (ItemStack excessItem : excessItems) {
                hunter.getWorld().dropItemNaturally(dropLocation, excessItem);
            }
            LOGGER.log(Level.INFO, "Dropped " + excessItems.size() + " excess items for " + hunter.getName() + " (inventory full)");
        }
    }
}

