/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.distribution;

import com.raindropcentral.rdq.bounty.distribution.RewardDistributor;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DropRewardDistributor
implements RewardDistributor {
    private static final Logger LOGGER = Logger.getLogger(DropRewardDistributor.class.getName());

    @Override
    @NotNull
    public CompletableFuture<Void> distributeRewards(@NotNull Player hunter, @NotNull Bounty bounty, @NotNull Location location, double proportion) {
        return CompletableFuture.runAsync(() -> {
            this.dropItems(location, bounty, proportion);
            LOGGER.log(Level.INFO, "Dropped bounty rewards at " + this.formatLocation(location));
        });
    }

    private void dropItems(@NotNull Location location, @NotNull Bounty bounty, double proportion) {
        for (BountyReward reward : bounty.getRewards()) {
            if (reward.getReward().getType() != Reward.Type.ITEM) continue;
            ItemReward itemReward = (ItemReward)reward.getReward();
            ItemStack item = itemReward.getItem().clone();
            int adjustedAmount = Math.max(1, (int)((double)item.getAmount() * proportion));
            item.setAmount(adjustedAmount);
            location.getWorld().dropItemNaturally(location, item);
        }
    }

    private String formatLocation(@NotNull Location location) {
        return String.format("%s (%.1f, %.1f, %.1f)", location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }
}

