/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.distribution;

import com.raindropcentral.rdq.bounty.distribution.RewardDistributor;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChestRewardDistributor
implements RewardDistributor {
    private static final Logger LOGGER = Logger.getLogger(ChestRewardDistributor.class.getName());

    @Override
    @NotNull
    public CompletableFuture<Void> distributeRewards(@NotNull Player hunter, @NotNull Bounty bounty, @NotNull Location location, double proportion) {
        return CompletableFuture.runAsync(() -> {
            Location chestLocation = this.findSafeChestLocation(location);
            if (chestLocation != null && this.placeChest(chestLocation, bounty, proportion)) {
                LOGGER.log(Level.INFO, "Placed bounty chest at " + this.formatLocation(chestLocation));
            } else {
                LOGGER.log(Level.WARNING, "Failed to place chest, dropping items instead");
                this.dropItems(location, bounty, proportion);
            }
        });
    }

    private Location findSafeChestLocation(@NotNull Location location) {
        Block block = location.getBlock();
        if (this.canPlaceChest(block)) {
            return block.getLocation();
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Block nearby = block.getRelative(x, y, z);
                    if (!this.canPlaceChest(nearby)) continue;
                    return nearby.getLocation();
                }
            }
        }
        return null;
    }

    private boolean canPlaceChest(@NotNull Block block) {
        return block.getType() == Material.AIR || block.getType().isAir();
    }

    private boolean placeChest(@NotNull Location location, @NotNull Bounty bounty, double proportion) {
        Block block = location.getBlock();
        block.setType(Material.CHEST);
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            Inventory inventory = chest.getInventory();
            for (BountyReward reward : bounty.getRewards()) {
                if (reward.getReward().getType() != Reward.Type.ITEM) continue;
                ItemReward itemReward = (ItemReward)reward.getReward();
                ItemStack item = itemReward.getItem().clone();
                int adjustedAmount = Math.max(1, (int)((double)item.getAmount() * proportion));
                item.setAmount(adjustedAmount);
                inventory.addItem(new ItemStack[]{item});
            }
            chest.update();
            return true;
        }
        return false;
    }

    private void dropItems(@NotNull Location location, @NotNull Bounty bounty, double proportion) {
        for (BountyReward reward : bounty.getRewards()) {
            if (reward.getReward().getType() != Reward.Type.ITEM) continue;
            ItemReward itemReward = (ItemReward)reward.getReward();
            ItemStack item = itemReward.getItem().clone();
            int adjustedAmount = Math.max(1, (int)((double)item.getAmount() * proportion));
            item.setAmount(adjustedAmount);
            location.getWorld().dropItemNaturally(location, item);
        }
    }

    private String formatLocation(@NotNull Location location) {
        return String.format("%s (%.1f, %.1f, %.1f)", location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }
}

