/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.claim;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public record ClaimResult(@NotNull Map<UUID, Double> winners) {
    public ClaimResult(@NotNull Map<UUID, Double> winners) {
        winners = Collections.unmodifiableMap(winners);
    }

    public static ClaimResult empty() {
        return new ClaimResult(Collections.emptyMap());
    }

    public static ClaimResult singleWinner(@NotNull UUID winner) {
        return new ClaimResult(Map.of(winner, 1.0));
    }

    public boolean hasWinners() {
        return !this.winners.isEmpty();
    }

    public int getWinnerCount() {
        return this.winners.size();
    }
}

