/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty.claim;

import com.raindropcentral.rdq.bounty.DamageTracker;
import com.raindropcentral.rdq.bounty.claim.ClaimResult;
import com.raindropcentral.rdq.bounty.type.EClaimMode;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimHandler {
    private final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final DamageTracker damageTracker;
    private final EClaimMode claimMode;
    private final boolean selfClaimAllowed;

    public ClaimHandler(@NotNull DamageTracker damageTracker, @NotNull EClaimMode claimMode, boolean selfClaimAllowed) {
        this.damageTracker = damageTracker;
        this.claimMode = claimMode;
        this.selfClaimAllowed = selfClaimAllowed;
        this.LOGGER.info("[ClaimHandler] Initialized with selfClaimAllowed=" + selfClaimAllowed + ", claimMode=" + String.valueOf((Object)claimMode));
    }

    @NotNull
    public ClaimResult determineClaim(@NotNull UUID victimUuid, @Nullable UUID lastHitterUuid) {
        Map<UUID, Double> damageMap = this.damageTracker.getDamageMap(victimUuid);
        this.LOGGER.info("[ClaimHandler] Determining claim - Victim: " + String.valueOf(victimUuid) + ", LastHitter: " + String.valueOf(lastHitterUuid) + ", DamageMap size: " + damageMap.size() + ", ClaimMode: " + String.valueOf((Object)this.claimMode));
        if (!damageMap.isEmpty()) {
            this.LOGGER.info("[ClaimHandler] Damage data: " + String.valueOf(damageMap));
        }
        if (lastHitterUuid == null || lastHitterUuid.equals(victimUuid)) {
            return this.handleEdgeCase(damageMap, lastHitterUuid, victimUuid);
        }
        return switch (this.claimMode) {
            default -> throw new MatchException(null, null);
            case EClaimMode.LAST_HIT -> this.handleLastHit(lastHitterUuid);
            case EClaimMode.MOST_DAMAGE -> this.handleMostDamage(damageMap, lastHitterUuid);
            case EClaimMode.DAMAGE_SPLIT -> this.handleDamageSplit(damageMap);
        };
    }

    @NotNull
    private ClaimResult handleLastHit(@NotNull UUID lastHitterUuid) {
        return ClaimResult.singleWinner(lastHitterUuid);
    }

    @NotNull
    private ClaimResult handleMostDamage(@NotNull Map<UUID, Double> damageMap, @NotNull UUID lastHitterUuid) {
        if (damageMap.isEmpty()) {
            return this.handleLastHit(lastHitterUuid);
        }
        UUID winner = damageMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(lastHitterUuid);
        return ClaimResult.singleWinner(winner);
    }

    @NotNull
    private ClaimResult handleDamageSplit(@NotNull Map<UUID, Double> damageMap) {
        if (damageMap.isEmpty()) {
            return ClaimResult.empty();
        }
        double totalDamage = damageMap.values().stream().mapToDouble(Double::doubleValue).sum();
        if (totalDamage <= 0.0) {
            return ClaimResult.empty();
        }
        HashMap<UUID, Double> shares = new HashMap<UUID, Double>();
        for (Map.Entry<UUID, Double> entry : damageMap.entrySet()) {
            double proportion = entry.getValue() / totalDamage;
            shares.put(entry.getKey(), proportion);
        }
        return new ClaimResult(shares);
    }

    @NotNull
    private ClaimResult handleEdgeCase(@NotNull Map<UUID, Double> damageMap, @Nullable UUID lastHitterUuid, @NotNull UUID victimUuid) {
        this.LOGGER.info("[ClaimHandler] handleEdgeCase: lastHitterUuid=" + String.valueOf(lastHitterUuid) + ", victimUuid=" + String.valueOf(victimUuid) + ", selfClaimAllowed=" + this.selfClaimAllowed + ", lastHitterNotNull=" + (lastHitterUuid != null) + ", uuidsEqual=" + (lastHitterUuid != null && lastHitterUuid.equals(victimUuid)));
        if (lastHitterUuid != null && lastHitterUuid.equals(victimUuid)) {
            if (this.selfClaimAllowed) {
                this.LOGGER.info("[ClaimHandler] Self-kill detected and self-claims are allowed - awarding bounty to self");
                return ClaimResult.singleWinner(lastHitterUuid);
            }
            this.LOGGER.info("[ClaimHandler] Self-kill detected but self-claims are DISABLED - no winner");
            this.LOGGER.info("[ClaimHandler] TEMPORARY: Forcing self-claim to work for testing");
            return ClaimResult.singleWinner(lastHitterUuid);
        }
        if (damageMap.isEmpty()) {
            this.LOGGER.info("[ClaimHandler] No damage data available - no winner (selfClaimAllowed=" + this.selfClaimAllowed + ")");
            return ClaimResult.empty();
        }
        UUID winner = damageMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        if (winner == null) {
            return ClaimResult.empty();
        }
        this.LOGGER.info("[ClaimHandler] Environmental death - awarding bounty to highest damage dealer: " + String.valueOf(winner));
        return ClaimResult.singleWinner(winner);
    }

    public void clearDamage(@NotNull UUID victimUuid) {
        this.damageTracker.clearDamage(victimUuid);
    }
}

