/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty;

import com.raindropcentral.rdq.bounty.IBountyService;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyHunter;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class FreeBountyService
implements IBountyService {
    private static final int MAX_BOUNTIES_PER_COMMISSIONER = 1;
    private static final int MAX_REWARDS_PER_BOUNTY = 1;
    private static final int FREE_HUNTER_LEVEL = 1;
    private static FreeBountyService instance;
    private final List<Bounty> mockBounties = new ArrayList<Bounty>();

    private FreeBountyService() {
    }

    public static FreeBountyService initialize(Object rdq) {
        if (instance == null) {
            instance = new FreeBountyService();
        }
        return instance;
    }

    public static FreeBountyService getInstance() {
        if (instance == null) {
            throw new IllegalStateException("FreeBountyService not initialized. Call initialize() first.");
        }
        return instance;
    }

    @Override
    public CompletableFuture<List<Bounty>> findAll(int page, int pageSize) {
        return CompletableFuture.supplyAsync(() -> {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, this.mockBounties.size());
            if (start >= this.mockBounties.size()) {
                return new ArrayList();
            }
            return new ArrayList<Bounty>(this.mockBounties.subList(start, end));
        });
    }

    @Override
    public CompletableFuture<Bounty> findPlayerBounty(@NotNull UUID uniqueId) {
        return CompletableFuture.supplyAsync(() -> this.mockBounties.stream().filter(bounty -> bounty.getTargetUniqueId().equals(uniqueId)).findFirst().orElse(null));
    }

    @Override
    public CompletableFuture<List<Bounty>> findBountiesByCommissioner(@NotNull UUID commissionerUniqueId) {
        return CompletableFuture.supplyAsync(() -> this.mockBounties.stream().filter(bounty -> bounty.getCommissionerUniqueId().equals(commissionerUniqueId)).toList());
    }

    @Override
    public CompletableFuture<Bounty> create(@NotNull UUID targetUniqueId, @NotNull UUID commissionerUniqueId) {
        return this.create(targetUniqueId, commissionerUniqueId, new ArrayList<BountyReward>());
    }

    @Override
    public CompletableFuture<Bounty> create(@NotNull UUID targetUniqueId, @NotNull UUID commissionerUniqueId, @NotNull List<BountyReward> rewards) {
        return CompletableFuture.supplyAsync(() -> {
            long commissionerBounties = this.mockBounties.stream().filter(b -> b.getCommissionerUniqueId().equals(commissionerUniqueId)).count();
            if (commissionerBounties >= 1L) {
                throw new IllegalStateException("Free version: Maximum 1 bounty per player. Upgrade to Premium!");
            }
            List limitedRewards = rewards.stream().limit(1L).toList();
            Bounty bounty = new Bounty(targetUniqueId, commissionerUniqueId, rewards);
            this.mockBounties.add(bounty);
            return bounty;
        });
    }

    @Override
    public CompletableFuture<Bounty> update(@NotNull Bounty bounty) {
        return CompletableFuture.supplyAsync(() -> bounty);
    }

    @Override
    public CompletableFuture<Boolean> delete(@NotNull Bounty bounty) {
        return CompletableFuture.supplyAsync(() -> this.mockBounties.remove(bounty));
    }

    @Override
    public CompletableFuture<Integer> getTotalBounties() {
        return CompletableFuture.completedFuture(this.mockBounties.size());
    }

    @Override
    public CompletableFuture<BountyHunter> getBountyHunter(@NotNull RDQPlayer player) {
        return CompletableFuture.supplyAsync(() -> null);
    }

    @Override
    public CompletableFuture<List<BountyHunter>> getTopHunters(int limit, @NotNull String orderBy) {
        return CompletableFuture.supplyAsync(ArrayList::new);
    }

    @Override
    public CompletableFuture<BountyHunter> claim(@NotNull RDQPlayer player, double rewardValue) {
        return CompletableFuture.supplyAsync(() -> null);
    }

    @Override
    public CompletableFuture<Integer> getHunterLevel(@NotNull UUID uniqueId) {
        return CompletableFuture.completedFuture(1);
    }

    @Override
    public boolean isPremium() {
        return false;
    }

    @Override
    public boolean canCreateBounty(@NotNull Player player) {
        long playerBounties = this.mockBounties.stream().filter(b -> b.getCommissionerUniqueId().equals(player.getUniqueId())).count();
        return playerBounties < 1L;
    }

    @Override
    public int getMaxBountiesPerCommissioner() {
        return 1;
    }

    @Override
    public int getMaxBountyRewardsPerTarget() {
        return 1;
    }
}

