/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.bounty;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DamageTracker {
    private final Map<UUID, List<DamageEvent>> damageMap = new ConcurrentHashMap<UUID, List<DamageEvent>>();
    private final long trackingWindowMs;

    public DamageTracker(long trackingWindowMs) {
        if (trackingWindowMs <= 0L) {
            throw new IllegalArgumentException("Tracking window must be positive");
        }
        this.trackingWindowMs = trackingWindowMs;
    }

    public void recordDamage(@NotNull UUID victimUuid, @NotNull UUID attackerUuid, double damage) {
        if (damage <= 0.0) {
            return;
        }
        DamageEvent event = new DamageEvent(attackerUuid, damage, Instant.now());
        this.damageMap.computeIfAbsent(victimUuid, k -> new ArrayList()).add(event);
    }

    @NotNull
    public Map<UUID, Double> getDamageMap(@NotNull UUID victimUuid) {
        List<DamageEvent> events = this.damageMap.get(victimUuid);
        if (events == null || events.isEmpty()) {
            return Collections.emptyMap();
        }
        Instant cutoff = Instant.now().minusMillis(this.trackingWindowMs);
        return events.stream().filter(event -> event.timestamp().isAfter(cutoff)).collect(Collectors.groupingBy(DamageEvent::attackerUuid, Collectors.summingDouble(DamageEvent::damage)));
    }

    public double getTotalDamage(@NotNull UUID victimUuid) {
        return this.getDamageMap(victimUuid).values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public void clearDamage(@NotNull UUID victimUuid) {
        this.damageMap.remove(victimUuid);
    }

    public void cleanupExpiredRecords() {
        Instant cutoff = Instant.now().minusMillis(this.trackingWindowMs);
        this.damageMap.entrySet().removeIf(entry -> {
            List events = (List)entry.getValue();
            events.removeIf(event -> event.timestamp().isBefore(cutoff));
            return events.isEmpty();
        });
    }

    public int getTrackedVictimCount() {
        return this.damageMap.size();
    }

    private record DamageEvent(@NotNull UUID attackerUuid, double damage, @NotNull Instant timestamp) {
    }
}

