/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.RDQFree;
import com.raindropcentral.rdq.bounty.FreeBountyService;
import com.raindropcentral.rdq.bounty.IBountyService;
import com.raindropcentral.rdq.rank.FreeRankSystemService;
import com.raindropcentral.rdq.rank.IRankSystemService;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.dependency.delegate.AbstractPluginDelegate;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewFrame;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RDQFreeImpl
extends AbstractPluginDelegate<RDQFree> {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private static final String EDITION = "Free";
    @Nullable
    private RDQ rdq;
    @Nullable
    private FreeBountyService bountyService;
    private static final String STARTUP_MESSAGE = "===============================================================================================\n            ____     ____      ___\n           |  _ \\   |  _ \\    / _ \\\n           | |_) |  | | | |  | | | |\n           |  _ <   | |_| |  | |_| |\n           |_| \\_\\  |____/    \\__\\_\\\n                RaindropQuests - Free Edition\n           Product of Antimatter Zone LLC\n           Powered by JExcellence\n===============================================================================================\nRank System: Enabled (Limited - Single Tree)\nBounty System: Enabled (Limited)\nPerk System: Enabled (Limited - Single Active Perk)\n===============================================================================================\nLanguage System: JExTranslate v3.0\nAdventure Components: Enabled\nDatabase: Connected\n===============================================================================================\nUpgrade to Premium for full features!\n===============================================================================================\n";

    public RDQFreeImpl(@NotNull RDQFree plugin) {
        super(plugin);
    }

    @Override
    public void onLoad() {
        try {
            this.rdq = new RDQ(this, (JavaPlugin)this.getPlugin(), EDITION){

                @Override
                @NotNull
                protected String getStartupMessage() {
                    return RDQFreeImpl.STARTUP_MESSAGE;
                }

                @Override
                protected int getMetricsId() {
                    return -1;
                }

                @Override
                @NotNull
                protected ViewFrame registerViews(@NotNull ViewFrame viewFrame) {
                    return viewFrame;
                }

                @Override
                @NotNull
                protected IBountyService createBountyService() {
                    return FreeBountyService.initialize(this);
                }

                @Override
                @NotNull
                protected IRankSystemService createRankSystemService() {
                    return FreeRankSystemService.initialize(this);
                }
            };
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to load RDQ (Free)", exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void onEnable() {
        if (this.rdq == null) {
            LOGGER.severe("Cannot enable - RDQ (Free) failed during onLoad.");
            ((RDQFree)((Object)this.getPlugin())).getServer().getPluginManager().disablePlugin(this.getPlugin());
            return;
        }
        this.rdq.onEnable();
    }

    @Override
    public void onDisable() {
        try {
            if (this.rdq != null) {
                this.rdq.onDisable();
            }
            LOGGER.info("RDQ (Free) Edition disabled successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error during RDQ (Free) shutdown", exception);
        }
    }
}

