/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq;

import com.raindropcentral.commands.CommandFactory;
import com.raindropcentral.rdq.bounty.IBountyService;
import com.raindropcentral.rdq.bounty.utility.BountyFactory;
import com.raindropcentral.rdq.bounty.visual.VisualIndicatorManager;
import com.raindropcentral.rdq.database.entity.RRequirement;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyHunter;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankPath;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankUpgradeProgress;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.repository.BountyHunterRepository;
import com.raindropcentral.rdq.database.repository.BountyRepository;
import com.raindropcentral.rdq.database.repository.RDQPlayerRepository;
import com.raindropcentral.rdq.database.repository.RPlayerRankPathRepository;
import com.raindropcentral.rdq.database.repository.RPlayerRankRepository;
import com.raindropcentral.rdq.database.repository.RPlayerRankUpgradeProgressRepository;
import com.raindropcentral.rdq.database.repository.RRankRepository;
import com.raindropcentral.rdq.database.repository.RRankTreeRepository;
import com.raindropcentral.rdq.database.repository.RRequirementRepository;
import com.raindropcentral.rdq.permissions.PermissionsService;
import com.raindropcentral.rdq.rank.IRankSystemService;
import com.raindropcentral.rdq.rank.RankSystemFactory;
import com.raindropcentral.rdq.service.RankPathService;
import com.raindropcentral.rdq.view.admin.AdminOverviewView;
import com.raindropcentral.rdq.view.admin.AdminPermissionsView;
import com.raindropcentral.rdq.view.bounty.BountyCreationView;
import com.raindropcentral.rdq.view.bounty.BountyMainView;
import com.raindropcentral.rdq.view.bounty.BountyOverviewView;
import com.raindropcentral.rdq.view.bounty.BountyPlayerInfoView;
import com.raindropcentral.rdq.view.bounty.BountyRewardView;
import com.raindropcentral.rdq.view.ranks.RankMainView;
import com.raindropcentral.rdq.view.ranks.RankPathOverview;
import com.raindropcentral.rdq.view.ranks.RankPathRankRequirementOverview;
import com.raindropcentral.rdq.view.ranks.RankRequirementDetailView;
import com.raindropcentral.rdq.view.ranks.RankRequirementsJourneyView;
import com.raindropcentral.rdq.view.ranks.RankTreeOverviewView;
import com.raindropcentral.rplatform.RPlatform;
import com.raindropcentral.rplatform.api.luckperms.LuckPermsService;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.service.ServiceRegistry;
import com.raindropcentral.rplatform.view.ConfirmationView;
import com.raindropcentral.rplatform.view.PaginatedPlayerView;
import de.jexcellence.hibernate.entity.BaseEntity;
import de.jexcellence.hibernate.repository.InjectRepository;
import de.jexcellence.hibernate.repository.RepositoryManager;
import de.jexcellence.remapped.me.devnatan.inventoryframework.AnvilInputFeature;
import de.jexcellence.remapped.me.devnatan.inventoryframework.PlatformView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.View;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewFrame;
import jakarta.persistence.EntityManagerFactory;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class RDQ {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final JavaPlugin plugin;
    private final String edition;
    private final ExecutorService executor;
    private final RPlatform platform;
    private volatile CompletableFuture<Void> onEnableFuture;
    private boolean disabling;
    private boolean postEnableCompleted;
    private ViewFrame viewFrame;
    private PermissionsService permissionsService;
    private RankSystemFactory rankSystemFactory;
    private RankPathService rankPathService;
    @InjectRepository
    private RDQPlayerRepository playerRepository;
    @InjectRepository
    private BountyRepository bountyRepository;
    @InjectRepository
    private BountyHunterRepository bountyHunterRepository;
    @InjectRepository
    private RPlayerRankPathRepository playerRankPathRepository;
    @InjectRepository
    private RPlayerRankRepository playerRankRepository;
    @InjectRepository
    private RPlayerRankUpgradeProgressRepository playerRankUpgradeProgressRepository;
    @InjectRepository
    private RRankRepository rankRepository;
    @InjectRepository
    private RRankTreeRepository rankTreeRepository;
    @InjectRepository
    private RRequirementRepository requirementRepository;
    private LuckPermsService luckPermsService;
    private IBountyService bountyService;
    private IRankSystemService rankSystemService;
    private BountyFactory bountyFactory;
    private VisualIndicatorManager visualIndicatorManager;

    public RDQ(@NotNull JavaPlugin plugin, @NotNull String edition) {
        this.plugin = plugin;
        this.edition = edition;
        this.platform = new RPlatform(plugin);
        this.executor = Executors.newFixedThreadPool(4);
    }

    public void onEnable() {
        if (this.onEnableFuture != null && !this.onEnableFuture.isDone()) {
            LOGGER.log(Level.WARNING, "Enable sequence already in progress");
            return;
        }
        this.onEnableFuture = ((CompletableFuture)((CompletableFuture)this.platform.initialize().thenCompose(v -> {
            this.initializeRepositories();
            return CompletableFuture.completedFuture(null);
        })).thenRun(() -> {
            this.initializeComponents();
            this.initializePlugins();
            this.initializeViews();
            this.platform.initializeMetrics(this.getMetricsId());
            this.rankPathService = new RankPathService(this);
            this.permissionsService = new PermissionsService(this);
            this.bountyService = this.createBountyService();
            this.bountyFactory = new BountyFactory(this, this.bountyService);
            this.rankSystemService = this.createRankSystemService();
            this.rankSystemFactory = new RankSystemFactory(this);
            this.rankSystemFactory.initialize();
            LOGGER.log(Level.INFO, "Rank system initialized");
            this.visualIndicatorManager = new VisualIndicatorManager(this);
            LOGGER.info(this.getStartupMessage());
            LOGGER.info("RDQ (" + this.edition + ") Edition enabled successfully!");
        })).exceptionally(throwable -> {
            LOGGER.log(Level.SEVERE, "Failed to initialize RDQ", (Throwable)throwable);
            return null;
        });
    }

    @NotNull
    protected abstract String getStartupMessage();

    protected abstract int getMetricsId();

    @NotNull
    protected abstract ViewFrame registerViews(@NotNull ViewFrame var1);

    @NotNull
    protected abstract IBountyService createBountyService();

    @NotNull
    protected abstract IRankSystemService createRankSystemService();

    private void initializeRepositories() {
        EntityManagerFactory emf = this.platform.getEntityManagerFactory();
        if (emf == null) {
            LOGGER.warning("EntityManagerFactory not initialized");
            return;
        }
        RepositoryManager.initialize(this.executor, emf);
        RepositoryManager repositoryManager = RepositoryManager.getInstance();
        repositoryManager.register(RDQPlayerRepository.class, RDQPlayer.class, RDQPlayer::getUniqueId);
        repositoryManager.register(BountyRepository.class, Bounty.class, BaseEntity::getId);
        repositoryManager.register(BountyHunterRepository.class, BountyHunter.class, BaseEntity::getId);
        repositoryManager.register(RPlayerRankPathRepository.class, RPlayerRankPath.class, BaseEntity::getId);
        repositoryManager.register(RPlayerRankRepository.class, RPlayerRank.class, BaseEntity::getId);
        repositoryManager.register(RPlayerRankUpgradeProgressRepository.class, RPlayerRankUpgradeProgress.class, BaseEntity::getId);
        repositoryManager.register(RRankRepository.class, RRank.class, RRank::getIdentifier);
        repositoryManager.register(RRankTreeRepository.class, RRankTree.class, RRankTree::getIdentifier);
        repositoryManager.register(RRequirementRepository.class, RRequirement.class, BaseEntity::getId);
        repositoryManager.injectInto(this);
    }

    private void initializeComponents() {
        CommandFactory commandFactory = new CommandFactory(this.plugin, this);
        commandFactory.registerAllCommandsAndListeners();
    }

    private void initializePlugins() {
        new ServiceRegistry().register("net.luckperms.api.LuckPerms", "LuckPerms").optional().maxAttempts(30).retryDelay(500L).onSuccess(luckPerms -> {
            this.luckPermsService = new LuckPermsService(this.platform);
            LOGGER.log(Level.INFO, "LuckPerms service initialized");
        }).onFailure(() -> LOGGER.log(Level.INFO, "LuckPerms service initialization failed, not present.")).load();
    }

    private void initializeViews() {
        ViewFrame frame = ((ViewFrame)((ViewFrame)ViewFrame.create((Plugin)this.plugin).install(AnvilInputFeature.AnvilInput).with((PlatformView[])new View[]{new ConfirmationView(), new AdminOverviewView(), new AdminPermissionsView(), new BountyMainView(), new BountyRewardView(), new BountyCreationView(), new BountyPlayerInfoView(), new BountyOverviewView(), new PaginatedPlayerView(), new RankMainView(), new RankTreeOverviewView(), new RankRequirementDetailView(), new RankPathOverview(), new RankPathRankRequirementOverview(), new RankRequirementsJourneyView()})).defaultConfig(config -> {
            config.cancelOnClick();
            config.cancelOnDrag();
            config.cancelOnDrop();
            config.cancelOnPickup();
            config.interactionDelay(Duration.ofMillis(100L));
        })).disableMetrics();
        frame = this.registerViews(frame);
        this.viewFrame = frame.register();
    }

    public void onDisable() {
        this.disabling = true;
        if (this.visualIndicatorManager != null) {
            this.visualIndicatorManager.shutdown();
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
        LOGGER.info("RDQ (" + this.edition + ") Edition disabled successfully!");
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getEdition() {
        return this.edition;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public RPlatform getPlatform() {
        return this.platform;
    }

    @Generated
    public CompletableFuture<Void> getOnEnableFuture() {
        return this.onEnableFuture;
    }

    @Generated
    public boolean isDisabling() {
        return this.disabling;
    }

    @Generated
    public boolean isPostEnableCompleted() {
        return this.postEnableCompleted;
    }

    @Generated
    public ViewFrame getViewFrame() {
        return this.viewFrame;
    }

    @Generated
    public PermissionsService getPermissionsService() {
        return this.permissionsService;
    }

    @Generated
    public RankSystemFactory getRankSystemFactory() {
        return this.rankSystemFactory;
    }

    @Generated
    public RankPathService getRankPathService() {
        return this.rankPathService;
    }

    @Generated
    public RDQPlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Generated
    public BountyRepository getBountyRepository() {
        return this.bountyRepository;
    }

    @Generated
    public BountyHunterRepository getBountyHunterRepository() {
        return this.bountyHunterRepository;
    }

    @Generated
    public RPlayerRankPathRepository getPlayerRankPathRepository() {
        return this.playerRankPathRepository;
    }

    @Generated
    public RPlayerRankRepository getPlayerRankRepository() {
        return this.playerRankRepository;
    }

    @Generated
    public RPlayerRankUpgradeProgressRepository getPlayerRankUpgradeProgressRepository() {
        return this.playerRankUpgradeProgressRepository;
    }

    @Generated
    public RRankRepository getRankRepository() {
        return this.rankRepository;
    }

    @Generated
    public RRankTreeRepository getRankTreeRepository() {
        return this.rankTreeRepository;
    }

    @Generated
    public RRequirementRepository getRequirementRepository() {
        return this.requirementRepository;
    }

    @Generated
    public LuckPermsService getLuckPermsService() {
        return this.luckPermsService;
    }

    @Generated
    public IBountyService getBountyService() {
        return this.bountyService;
    }

    @Generated
    public IRankSystemService getRankSystemService() {
        return this.rankSystemService;
    }

    @Generated
    public BountyFactory getBountyFactory() {
        return this.bountyFactory;
    }

    @Generated
    public VisualIndicatorManager getVisualIndicatorManager() {
        return this.visualIndicatorManager;
    }
}

