/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.commands;

import com.raindropcentral.commands.BukkitCommand;
import de.jexcellence.evaluable.error.CommandError;
import de.jexcellence.evaluable.error.EErrorType;
import de.jexcellence.evaluable.section.ACommandSection;
import de.jexcellence.evaluable.section.IPermissionNode;
import de.jexcellence.evaluable.section.PermissionsSection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerCommand
extends BukkitCommand {
    protected PlayerCommand(@NotNull ACommandSection commandSection) {
        super(commandSection);
    }

    protected abstract void onPlayerInvocation(@NotNull Player var1, @NotNull String var2, @NotNull String[] var3);

    @Override
    protected void onInvocation(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            throw new CommandError(null, EErrorType.NOT_A_PLAYER);
        }
        Player player = (Player)sender;
        this.onPlayerInvocation(player, alias, args);
    }

    @Override
    protected List<String> onTabCompletion(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        return this.onPlayerTabCompletion(player, alias, args);
    }

    protected boolean hasNoPermission(@NotNull Player player, @NotNull IPermissionNode permissionNode) {
        PermissionsSection permissionsSection = this.commandSection.getPermissions();
        if (permissionsSection == null) {
            return false;
        }
        if (permissionsSection.hasPermission(player, permissionNode)) {
            return false;
        }
        permissionsSection.sendMissingMessage(player, permissionNode);
        return true;
    }

    protected abstract List<String> onPlayerTabCompletion(@NotNull Player var1, @NotNull String var2, @NotNull String[] var3);
}

