/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.commands;

import com.google.common.reflect.ClassPath;
import com.raindropcentral.commands.BukkitCommand;
import com.raindropcentral.commands.utility.Command;
import de.jexcellence.configmapper.ConfigMapper;
import de.jexcellence.evaluable.CommandUpdater;
import de.jexcellence.evaluable.ConfigKeeper;
import de.jexcellence.evaluable.ConfigManager;
import de.jexcellence.evaluable.section.ACommandSection;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandFactory {
    private static final String COMMANDS_FOLDER = "commands";
    private static final String PERMISSIONS_SECTION = "permissions";
    private final JavaPlugin loadedPlugin;
    private final Object contextObject;
    private final CommandUpdater commandUpdater;

    public CommandFactory(@NotNull JavaPlugin loadedPlugin) {
        this(loadedPlugin, null);
    }

    public CommandFactory(@NotNull JavaPlugin loadedPlugin, @Nullable Object contextObject) {
        this.loadedPlugin = loadedPlugin;
        this.contextObject = contextObject;
        this.commandUpdater = new CommandUpdater((Plugin)this.loadedPlugin);
    }

    public void registerAllCommandsAndListeners() {
        try {
            ClassPath.from((ClassLoader)this.loadedPlugin.getClass().getClassLoader()).getAllClasses().stream().filter(classInfo -> classInfo.getPackageName().contains("command")).map(classInfo -> {
                try {
                    return classInfo.load();
                }
                catch (Exception ignored) {
                    return null;
                }
            }).filter(clazz -> clazz != null && clazz.isAnnotationPresent(Command.class)).forEach(this::registerCommand);
            ClassPath.from((ClassLoader)this.loadedPlugin.getClass().getClassLoader()).getAllClasses().stream().filter(classInfo -> classInfo.getPackageName().contains("listener")).map(ClassPath.ClassInfo::load).forEach(clazz -> {
                if (Listener.class.isAssignableFrom((Class<?>)clazz)) {
                    this.registerListener((Class<?>)clazz);
                }
            });
        }
        catch (Exception exception) {
            this.loadedPlugin.getLogger().log(Level.WARNING, "Could not register commands or listeners", exception);
        }
    }

    private void registerCommand(Class<?> commandClass) {
        try {
            String className = commandClass.getSimpleName();
            char prefix = className.charAt(0);
            String sectionClassName = prefix + className.substring(1) + "Section";
            String configFileName = prefix + className.substring(1) + ".yml";
            String packageName = commandClass.getPackageName();
            Class<?> sectionClass = Class.forName(packageName + "." + sectionClassName);
            ACommandSection mapSection = this.getACommandSection(configFileName, sectionClass, className);
            BukkitCommand command = null;
            try {
                Constructor<?> selectedConstructor = null;
                Object secondArg = null;
                for (Constructor<?> ctor : commandClass.getDeclaredConstructors()) {
                    Class<?>[] paramTypes = ctor.getParameterTypes();
                    if (paramTypes.length != 2 || !paramTypes[0].isAssignableFrom(mapSection.getClass())) continue;
                    Class<?> secondParamType = paramTypes[1];
                    if (this.contextObject != null && secondParamType.equals(this.contextObject.getClass())) {
                        selectedConstructor = ctor;
                        secondArg = this.contextObject;
                        break;
                    }
                    if (this.contextObject != null && secondParamType.isAssignableFrom(this.contextObject.getClass())) {
                        selectedConstructor = ctor;
                        secondArg = this.contextObject;
                        break;
                    }
                    if (secondParamType.isAssignableFrom(this.loadedPlugin.getClass())) {
                        selectedConstructor = ctor;
                        secondArg = this.loadedPlugin;
                        continue;
                    }
                    if (!this.isAssignableFromSuperclass(secondParamType, this.loadedPlugin.getClass())) continue;
                    selectedConstructor = ctor;
                    secondArg = this.loadedPlugin;
                }
                if (selectedConstructor == null) {
                    this.loadedPlugin.getLogger().log(Level.WARNING, "No compatible constructor found for command: " + commandClass.getName() + " (requires constructor with ACommandSection and JavaPlugin or context object)");
                    return;
                }
                command = (BukkitCommand)((Object)selectedConstructor.newInstance(mapSection, secondArg));
                this.loadedPlugin.getLogger().info("Registered command: " + commandClass.getSimpleName() + " with " + secondArg.getClass().getSimpleName());
            }
            catch (Exception exception) {
                this.loadedPlugin.getLogger().log(Level.WARNING, "Could not register command '" + commandClass.getName() + "'", exception);
                return;
            }
            if (className.equalsIgnoreCase("pr18n")) {
                command.setName(this.loadedPlugin.getName().toLowerCase() + ":pr18n");
                command.getAliases().add(this.loadedPlugin.getName().toLowerCase() + "reloadI18n");
            }
            this.commandUpdater.tryRegisterCommand(command);
            this.commandUpdater.trySyncCommands();
        }
        catch (Exception exception) {
            this.loadedPlugin.getLogger().log(Level.WARNING, "Could not register command: " + commandClass.getName(), exception);
        }
    }

    private ACommandSection getACommandSection(String configFileName, Class<? extends ACommandSection> sectionClass, String className) throws Exception {
        ConfigManager cfgManager = new ConfigManager((Plugin)this.loadedPlugin, COMMANDS_FOLDER);
        ConfigMapper cfgMapper = cfgManager.loadConfig(configFileName.toLowerCase());
        ConfigKeeper<? extends ACommandSection> cfgKeeper = new ConfigKeeper<ACommandSection>(cfgManager, configFileName.toLowerCase(), sectionClass);
        return cfgKeeper.mapSection("commands." + className.toLowerCase());
    }

    private boolean isAssignableFromSuperclass(Class<?> targetType, Class<?> sourceClass) {
        for (Class<?> current = sourceClass.getSuperclass(); current != null; current = current.getSuperclass()) {
            if (!targetType.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    private void registerListener(@NotNull Class<?> listenerClass) {
        try {
            if (!Listener.class.isAssignableFrom(listenerClass)) {
                return;
            }
            Listener listener = null;
            Constructor<?> selectedConstructor = null;
            Object constructorArg = null;
            for (Constructor<?> ctor : listenerClass.getDeclaredConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (paramTypes.length != 1) continue;
                Class<?> paramType = paramTypes[0];
                if (this.contextObject != null && paramType.equals(this.contextObject.getClass())) {
                    selectedConstructor = ctor;
                    constructorArg = this.contextObject;
                    break;
                }
                if (this.contextObject != null && paramType.isAssignableFrom(this.contextObject.getClass())) {
                    selectedConstructor = ctor;
                    constructorArg = this.contextObject;
                    break;
                }
                if (!paramType.isAssignableFrom(this.loadedPlugin.getClass())) continue;
                selectedConstructor = ctor;
                constructorArg = this.loadedPlugin;
            }
            if (selectedConstructor != null) {
                listener = (Listener)selectedConstructor.newInstance(constructorArg);
                this.loadedPlugin.getServer().getPluginManager().registerEvents(listener, (Plugin)this.loadedPlugin);
                this.loadedPlugin.getLogger().info("Registered listener: " + listenerClass.getSimpleName() + " with " + constructorArg.getClass().getSimpleName());
            } else {
                this.loadedPlugin.getLogger().log(Level.WARNING, "No compatible constructor found for listener: " + listenerClass.getName() + " (requires JavaPlugin or context object)");
            }
        }
        catch (Exception exception) {
            this.loadedPlugin.getLogger().log(Level.WARNING, "Could not register listener: " + listenerClass.getName(), exception);
        }
    }

    @NotNull
    public JavaPlugin getLoadedPlugin() {
        return this.loadedPlugin;
    }

    @Nullable
    public Object getContextObject() {
        return this.contextObject;
    }
}

