/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.utils;

import com.google.gson.Gson;
import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.data.KitData;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.enums.ServerVersion;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.bson.json.JsonMode;
import io.github.InsiderAnh.xPlayerKits.libs.bson.json.JsonWriterSettings;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class XPKUtils {
    public static final ServerVersion SERVER_VERSION;
    private static final PlayerKits playerKits;
    private static final Gson gson;
    private static final JsonWriterSettings writerSettings;
    private static final Pattern pattern;
    public static int[] SLOTS;

    public static void claimKit(Player player, Kit kit, PlayerKitData playerKitData) {
        if (kit.isNoHasRequirements(player)) {
            player.sendMessage(playerKits.getLang().getString("messages.noRequirements"));
            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (!kit.getPermission().equals("none") && !player.hasPermission(kit.getPermission())) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.noPermissionKit"));
            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
            return;
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        if (kit.isOneTime() && kitData != null && kitData.isOneTime() && !player.hasPermission("xkits.onetime.bypass")) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.alreadyOneTime"));
            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (kitData != null && kitData.getCountdown() > System.currentTimeMillis() && !player.hasPermission("xkits.countdown.bypass")) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.waitCountdown").replace("<time>", XPKUtils.millisToLongDHMS(kitData.getCountdown() - System.currentTimeMillis())));
            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (kit.isCheckInventorySpace() && kit.isNoInventorySpace(player)) {
            XPKUtils.executeActions(player, kit.getActionsOnDeny());
            player.sendMessage(playerKits.getLang().getString("messages.noInventorySpace"));
            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
            return;
        }
        playerKitData.getKitsData().put(kit.getName(), new KitData(kit.getName(), System.currentTimeMillis() + kit.getCountdown() * 1000L, kit.isOneTime(), false));
        playerKits.getExecutor().execute(() -> {
            playerKits.getDatabase().updatePlayerData(player.getUniqueId());
            Bukkit.getScheduler().runTask((Plugin)playerKits, () -> kit.giveKit(player));
        });
    }

    public static String getStatus(boolean bool) {
        return PlayerKits.getInstance().getLang().getString("messages." + (bool ? "enabled" : "disabled"));
    }

    public static String color(String message) {
        return XPKUtils.translateAlternateColorCodes('&', message);
    }

    public static String translateAlternateColorCodes(char altColorChar, String message) {
        if (SERVER_VERSION.serverVersionGreaterEqualThan(ServerVersion.v1_16)) {
            Matcher matcher = pattern.matcher(message);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                try {
                    ChatColor chatColor = ChatColor.of((String)color);
                    matcher.appendReplacement(stringBuffer, chatColor.toString());
                }
                catch (Exception exception) {}
            }
            matcher.appendTail(stringBuffer);
            message = stringBuffer.toString();
        }
        return ChatColor.translateAlternateColorCodes((char)altColorChar, (String)message);
    }

    public static ItemStack applySimpleTag(ItemStack item, String key, String value) {
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setString(key, value);
        nbtItem.mergeNBT(item);
        return item;
    }

    public static boolean isHelmet(String material) {
        return material.endsWith("_HELMET") || material.equals("PLAYER_HEAD") || material.equals("SKULL_ITEM");
    }

    public static boolean isChestplate(String material) {
        return material.endsWith("_CHESTPLATE") || material.equals("ELYTRA");
    }

    public static boolean isLeggings(String material) {
        return material.endsWith("_LEGGINGS");
    }

    public static boolean isBoots(String material) {
        return material.endsWith("_BOOTS");
    }

    public static void executeActions(Player player, ArrayList<String> actions) {
        block12: for (String action : actions) {
            if (action.equals("none")) continue;
            String actionType = action.split(":")[0].toLowerCase();
            String actionData = action.split(":")[1];
            switch (actionType) {
                case "console": {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)actionData.replaceAll("<player>", player.getName()).replaceFirst("/", ""));
                    break;
                }
                case "command": {
                    player.chat(actionData.replaceAll("<player>", player.getName()));
                    break;
                }
                case "sound": {
                    String[] subData = actionData.split(";");
                    try {
                        Sound sound = XSound.matchXSound(subData[0]).orElse(XSound.BLOCK_NOTE_BLOCK_PLING).parseSound();
                        float volume = Float.parseFloat(subData[1]);
                        float pitch = Float.parseFloat(subData[2]);
                        if (sound == null) continue block12;
                        player.playSound(player.getLocation(), sound, volume, pitch);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PlayerKits.getInstance().getLogger().warning("Error on execute sound format.");
                    }
                }
            }
        }
    }

    public static boolean passCondition(Player player, String condition) {
        String[] sep = condition.split(" ");
        String variable = PlaceholderAPI.setPlaceholders((Player)player, (String)sep[0]);
        String conditional = sep[1];
        try {
            double valueFinal = Double.parseDouble(sep[2]);
            double valueFinalVariable = Double.parseDouble(variable);
            switch (conditional) {
                case ">=": {
                    return valueFinalVariable >= valueFinal;
                }
                case "<=": {
                    return valueFinalVariable <= valueFinal;
                }
                case "==": {
                    return variable.equals(sep[2]);
                }
                case "!=": {
                    return !variable.equals(sep[2]);
                }
                case ">": {
                    return valueFinalVariable > valueFinal;
                }
                case "<": {
                    return valueFinalVariable < valueFinal;
                }
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return false;
        }
    }

    public static String millisToLongDHMS(long millis) {
        StringBuilder time = new StringBuilder();
        boolean space = false;
        if (millis >= 1000L) {
            long l = millis / 86400000L;
            if (l > 0L) {
                space = true;
                millis -= l * 86400000L;
                time.append(l).append("d");
            }
            if (space) {
                time.append(" ");
                space = false;
            }
            if ((l = millis / 3600000L) > 0L) {
                space = true;
                millis -= l * 3600000L;
                time.append(l).append("h");
            }
            if (space) {
                time.append(" ");
                space = false;
            }
            if ((l = millis / 60000L) > 0L) {
                space = true;
                millis -= l * 60000L;
                time.append(l).append("m");
            }
            if ((l = millis / 1000L) > 0L) {
                if (space) {
                    time.append(" ");
                }
                time.append(l).append(l > 1L ? "s" : "");
            }
            return time.toString();
        }
        return "0";
    }

    @Generated
    private XPKUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }

    @Generated
    public static JsonWriterSettings getWriterSettings() {
        return writerSettings;
    }

    static {
        playerKits = PlayerKits.getInstance();
        pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        gson = new Gson();
        writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = Bukkit.getServer().getBukkitVersion();
        }
        SERVER_VERSION = ServerVersion.get(detectedVersion);
    }
}

