/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus.setup;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.anvilgui.AnvilGUI;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XMaterial;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitContentMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitEditorMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final Kit kit;

    public KitEditorMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getLang().getString("menus.newKit.title"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("icon")) {
            String icon = nbtItem.getString("icon");
            ItemStack itemStack = player.getItemInHand();
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                player.sendMessage(this.playerKits.getLang().getString("messages.noItemHand"));
                player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                return;
            }
            this.kit.getIcons().put(icon, itemStack);
            player.sendMessage(this.playerKits.getLang().getString("messages.setIcon"));
            player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
            this.onUpdate(this.getInventory());
            return;
        }
        if (nbtItem.hasTag("action")) {
            String action;
            switch (action = nbtItem.getString("action")) {
                case "save": {
                    this.kit.save();
                    this.playerKits.getKitManager().load();
                    player.sendMessage(this.playerKits.getLang().getString("messages.savedKit"));
                    player.playSound(player.getLocation(), XSound.ENTITY_PLAYER_LEVELUP.parseSound(), 1.0f, 1.0f);
                    this.close();
                    return;
                }
                case "armor": {
                    new KitContentMenu(player, this.kit).open();
                    return;
                }
                case "inv": {
                    new KitContentMenu(player, this.kit).open();
                    return;
                }
                case "oneTime": {
                    this.kit.setOneTime(!this.kit.isOneTime());
                    player.sendMessage(this.playerKits.getLang().getString("messages.setOneTime").replace("<state>", XPKUtils.getStatus(this.kit.isOneTime())));
                    player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                    return;
                }
                case "autoArmor": {
                    this.kit.setAutoArmor(!this.kit.isAutoArmor());
                    player.sendMessage(this.playerKits.getLang().getString("messages.setAutoArmor").replace("<state>", XPKUtils.getStatus(this.kit.isAutoArmor())));
                    player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                    return;
                }
                case "name": {
                    new AnvilGUI.Builder().plugin((Plugin)this.playerKits).onClick((slot, type) -> {
                        if (type.getText().length() > 36) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.longName"));
                            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText("\u00a7cLong name"));
                        }
                        this.playerKits.getKitManager().removeKit(this.kit.getName());
                        this.kit.setName(type.getText());
                        this.playerKits.getKitManager().addKit(this.kit);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setName").replace("<name>", this.kit.getName()));
                        player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).text("Write a name").title("Write a kit name").open(player);
                    return;
                }
                case "countdown": {
                    new AnvilGUI.Builder().plugin((Plugin)this.playerKits).onClick((slot, type) -> {
                        long seconds;
                        try {
                            seconds = Long.parseLong(type.getText());
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText("\u00a7cWrite a valid number"));
                        }
                        this.kit.setCountdown(seconds);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setCountdown").replace("<countdown>", String.valueOf(this.kit.getCountdown())));
                        player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).text("Write a countdown").title("Write a kit countdown").open(player);
                    return;
                }
                case "slot": {
                    new AnvilGUI.Builder().plugin((Plugin)this.playerKits).onClick((slot, type) -> {
                        int slotI;
                        try {
                            slotI = Integer.parseInt(type.getText());
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText("\u00a7cWrite a valid number"));
                        }
                        this.kit.setSlot(slotI);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setSlot").replace("<slot>", String.valueOf(this.kit.getSlot())));
                        player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).text("Write a slot").title("Write a kit slot").open(player);
                    return;
                }
                case "page": {
                    new AnvilGUI.Builder().plugin((Plugin)this.playerKits).onClick((slot, type) -> {
                        int page;
                        try {
                            page = Integer.parseInt(type.getText());
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText("\u00a7cWrite a valid number"));
                        }
                        this.kit.setPage(page);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setPage").replace("<page>", String.valueOf(this.kit.getPage())));
                        player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).text("Write a page").title("Write a kit page").open(player);
                    return;
                }
                case "price": {
                    new AnvilGUI.Builder().plugin((Plugin)this.playerKits).onClick((slot, type) -> {
                        double amount;
                        try {
                            amount = Double.parseDouble(type.getText());
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText("\u00a7cWrite a valid number"));
                        }
                        this.kit.setPrice(amount);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setPrice").replace("<price>", String.valueOf(this.kit.getPrice())));
                        player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).text("Write a price").title("Write a kit price").open(player);
                    return;
                }
                case "permission": {
                    new AnvilGUI.Builder().plugin((Plugin)this.playerKits).onClick((slot, type) -> {
                        if (type.getText().contains(" ")) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.permissionNoSpace"));
                            player.playSound(player.getLocation(), XSound.ENTITY_ENDERMAN_TELEPORT.parseSound(), 1.0f, 1.0f);
                            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText("\u00a7cRemove spaces"));
                        }
                        this.kit.setName(type.getText());
                        player.sendMessage(this.playerKits.getLang().getString("messages.setName").replace("<name>", this.kit.getName()));
                        player.playSound(player.getLocation(), XSound.BLOCK_NOTE_BLOCK_PLING.parseSound(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }).text("Write a permission").title("Write a kit permission").open(player);
                }
            }
        }
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        ItemStack name = new ItemUtils(XMaterial.PAPER.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.name.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.name.loreItem").replace("<name>", this.kit.getName())).build();
        ItemStack countdown = new ItemUtils(XMaterial.CLOCK.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.countdown.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.countdown.loreItem").replace("<countdown>", String.valueOf(this.kit.getCountdown()))).build();
        ItemStack oneTime = new ItemUtils(XMaterial.EMERALD.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.oneTime.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.oneTime.loreItem").replace("<state>", XPKUtils.getStatus(this.kit.isOneTime()))).build();
        ItemStack autoArmor = new ItemUtils(XMaterial.DIAMOND_HELMET.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.autoArmor.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.autoArmor.loreItem").replace("<state>", XPKUtils.getStatus(this.kit.isAutoArmor()))).build();
        ItemStack permission = new ItemUtils(XMaterial.BARRIER.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.permission.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.permission.loreItem").replace("<permission>", this.kit.getPermission())).build();
        ItemStack armor = new ItemUtils(XMaterial.IRON_CHESTPLATE.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.armor.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.armor.loreItem")).build();
        ItemStack inv = new ItemUtils(XMaterial.CHEST.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.inv.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.inv.loreItem")).build();
        ItemStack slot = new ItemUtils(XMaterial.GHAST_TEAR.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.slot.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.slot.loreItem").replace("<slot>", String.valueOf(this.kit.getSlot()))).build();
        ItemStack page = new ItemUtils(XMaterial.MAP.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.page.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.page.loreItem").replace("<page>", String.valueOf(this.kit.getPage()))).build();
        ItemStack price = new ItemUtils(XMaterial.GOLD_NUGGET.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.price.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.price.loreItem").replace("<price>", String.valueOf(this.kit.getPrice()))).build();
        ItemStack requirements = new ItemUtils(XMaterial.BOOK.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.requirements.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.requirements.loreItem").replace("<requirements>", this.kit.getRequirementsString())).build();
        ItemStack claimCommands = new ItemUtils(XMaterial.GOLD_INGOT.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.claimCommands.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.claimCommands.loreItem").replace("<claimCommands>", this.kit.getActionsOnClaimString())).build();
        ItemStack denyCommands = new ItemUtils(XMaterial.REDSTONE.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.denyCommands.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.denyCommands.loreItem").replace("<denyCommands>", this.kit.getActionsOnDenyString())).build();
        ItemStack save = new ItemUtils(XMaterial.NETHER_STAR.parseMaterial()).displayName(this.playerKits.getLang().getString("menus.newKit.save.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.save.loreItem")).build();
        inventory.setItem(10, XPKUtils.applySimpleTag(name, "action", "name"));
        inventory.setItem(11, XPKUtils.applySimpleTag(countdown, "action", "countdown"));
        inventory.setItem(12, XPKUtils.applySimpleTag(oneTime, "action", "oneTime"));
        inventory.setItem(13, XPKUtils.applySimpleTag(autoArmor, "action", "autoArmor"));
        inventory.setItem(14, XPKUtils.applySimpleTag(permission, "action", "permission"));
        inventory.setItem(15, XPKUtils.applySimpleTag(armor, "action", "armor"));
        inventory.setItem(16, XPKUtils.applySimpleTag(inv, "action", "inv"));
        inventory.setItem(19, XPKUtils.applySimpleTag(slot, "action", "slot"));
        inventory.setItem(20, XPKUtils.applySimpleTag(page, "action", "page"));
        inventory.setItem(21, XPKUtils.applySimpleTag(price, "action", "price"));
        inventory.setItem(22, XPKUtils.applySimpleTag(requirements, "action", "requirements"));
        inventory.setItem(23, XPKUtils.applySimpleTag(claimCommands, "action", "claimCommands"));
        inventory.setItem(24, XPKUtils.applySimpleTag(denyCommands, "action", "denyCommands"));
        ItemStack icons = new ItemUtils(XMaterial.GREEN_STAINED_GLASS_PANE.parseItem()).displayName(this.playerKits.getLang().getString("menus.newKit.icons.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.icons.loreItem").replace("<denyCommands>", this.kit.getActionsOnDenyString())).build();
        for (int i = 28; i <= 34; ++i) {
            inventory.setItem(i, icons);
        }
        AtomicInteger indexIcons = new AtomicInteger();
        for (String key : this.kit.getIcons().keySet()) {
            ItemStack icon = new ItemUtils(this.kit.getIcons().get(key)).displayName(this.playerKits.getLang().getString("menus.newKit." + key + ".nameItem")).lore(this.playerKits.getLang().getString("menus.newKit." + key + ".loreItem")).build();
            inventory.setItem(37 + indexIcons.getAndIncrement(), XPKUtils.applySimpleTag(icon, "icon", key));
        }
        inventory.setItem(53, XPKUtils.applySimpleTag(save, "action", "save"));
    }
}

