/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus.setup;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.enums.ServerVersion;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XMaterial;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitEditorMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class KitContentMenu
extends AInventory {
    private final PlayerKits plugin = PlayerKits.getInstance();
    private final Kit kit;

    public KitContentMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getLang().getString("menus.kitContent.title"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        NBTItem nbtItem = new NBTItem(currentItem);
        Player player = this.getPlayer();
        Inventory inventory = this.getInventory();
        if (nbtItem.hasTag("itemId")) {
            String itemId = nbtItem.getString("itemId");
            if (itemId.equals("save")) {
                ItemStack offhand;
                ItemStack[] inv = new ItemStack[36];
                for (int i = 0; i < 36; ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (item == null || item.getType().equals((Object)XMaterial.AIR.parseMaterial())) continue;
                    inv[i] = item;
                }
                this.kit.setInventory(inv);
                ItemStack[] armor = new ItemStack[4];
                for (int i = 0; i < 4; ++i) {
                    ItemStack item = inventory.getItem(i + 45);
                    if (item == null || item.getType().equals((Object)XMaterial.AIR.parseMaterial())) continue;
                    armor[3 - i] = item;
                }
                this.kit.setArmor(armor);
                if (XPKUtils.SERVER_VERSION.serverVersionGreaterEqualThan(ServerVersion.v1_9) && (offhand = inventory.getItem(50)) != null && !offhand.getType().equals((Object)XMaterial.AIR.parseMaterial())) {
                    this.kit.setOffhand(offhand);
                }
                player.sendMessage(this.plugin.getLang().getString("messages.savedInventory"));
                player.playSound(player.getLocation(), XSound.ENTITY_PLAYER_LEVELUP.parseSound(), 1.0f, 1.0f);
                new KitEditorMenu(this.getPlayer(), this.kit).open();
            }
            canceled.accept(true);
        }
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        ItemStack off;
        ItemStack item;
        int i;
        for (i = 0; i < 36; ++i) {
            item = this.kit.getInventory()[i];
            if (item == null || item.getType().equals((Object)XMaterial.AIR.parseMaterial())) continue;
            inventory.setItem(i, item);
        }
        for (i = 0; i < 4; ++i) {
            item = this.kit.getArmor()[i];
            if (item == null || item.getType().equals((Object)XMaterial.AIR.parseMaterial())) continue;
            inventory.setItem(48 - i, item);
        }
        if (XPKUtils.SERVER_VERSION.serverVersionGreaterEqualThan(ServerVersion.v1_9) && (off = this.kit.getOffhand()) != null && !off.getType().equals((Object)XMaterial.AIR.parseMaterial())) {
            inventory.setItem(50, off);
        }
        ItemStack helmet = new ItemUtils(XMaterial.WHITE_STAINED_GLASS_PANE.parseItem()).displayName(this.plugin.getLang().getString("menus.kitContent.helmet.nameItem")).build();
        ItemStack chestplate = new ItemUtils(XMaterial.WHITE_STAINED_GLASS_PANE.parseItem()).displayName(this.plugin.getLang().getString("menus.kitContent.chestplate.nameItem")).build();
        ItemStack leggings = new ItemUtils(XMaterial.WHITE_STAINED_GLASS_PANE.parseItem()).displayName(this.plugin.getLang().getString("menus.kitContent.leggings.nameItem")).build();
        ItemStack boots = new ItemUtils(XMaterial.WHITE_STAINED_GLASS_PANE.parseItem()).displayName(this.plugin.getLang().getString("menus.kitContent.boots.nameItem")).build();
        ItemStack save = new ItemUtils(XMaterial.NETHER_STAR.parseItem()).displayName(this.plugin.getLang().getString("menus.kitContent.save.nameItem")).lore(this.plugin.getLang().getString("menus.kitContent.save.loreItem")).build();
        ItemStack glass = XPKUtils.applySimpleTag(new ItemUtils(XMaterial.WHITE_STAINED_GLASS_PANE.parseItem()).displayName("\u00a77").build(), "itemId", "glass");
        inventory.setItem(36, XPKUtils.applySimpleTag(helmet, "itemId", "helmet"));
        inventory.setItem(37, XPKUtils.applySimpleTag(chestplate, "itemId", "chestplate"));
        inventory.setItem(38, XPKUtils.applySimpleTag(leggings, "itemId", "leggings"));
        inventory.setItem(39, XPKUtils.applySimpleTag(boots, "itemId", "boots"));
        inventory.setItem(40, glass);
        inventory.setItem(42, glass);
        inventory.setItem(43, glass);
        inventory.setItem(44, glass);
        inventory.setItem(49, glass);
        inventory.setItem(51, glass);
        inventory.setItem(52, glass);
        inventory.setItem(53, XPKUtils.applySimpleTag(save, "itemId", "save"));
        if (XPKUtils.SERVER_VERSION.serverVersionGreaterEqualThan(ServerVersion.v1_9)) {
            ItemStack offhand = new ItemUtils(XMaterial.WHITE_STAINED_GLASS_PANE.parseItem()).displayName(this.plugin.getLang().getString("menus.kitContent.offhand.nameItem")).build();
            inventory.setItem(41, XPKUtils.applySimpleTag(offhand, "itemId", "offhand"));
        } else {
            inventory.setItem(41, glass);
            inventory.setItem(50, glass);
        }
    }
}

