/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.data.KitData;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.menus.KitPreviewMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class KitsMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final HashMap<Integer, ItemStack> kitsMenu = new HashMap();
    private final HashMap<String, Integer> slotsNumbers = new HashMap();
    private final PlayerKitData playerKitData;
    private int page;

    public KitsMenu(Player player, PlayerKitData playerKitData, int page) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getLang().getString("menus.kitsMenu.title"));
        this.playerKitData = playerKitData;
        this.page = page;
        InsiderConfig inventories = this.playerKits.getInventories();
        for (int slot = 0; slot < 54; ++slot) {
            if (!inventories.isSet("inventories.kits." + slot)) continue;
            ItemStack itemStack = inventories.getConfig().getItemStack("inventories.kits." + slot);
            this.kitsMenu.put(slot, itemStack);
            if (itemStack == null || itemStack.getItemMeta() == null || !itemStack.getItemMeta().hasDisplayName()) continue;
            this.slotsNumbers.put(itemStack.getItemMeta().getDisplayName(), slot);
        }
        this.onUpdate(this.getInventory());
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("action")) {
            String action = nbtItem.getString("action");
            if (action.equals("close")) {
                this.close();
            }
            if (action.equals("last")) {
                ++this.page;
                this.onUpdate(this.getInventory());
            }
            if (action.equals("next")) {
                --this.page;
                this.onUpdate(this.getInventory());
            }
        }
        if (nbtItem.hasTag("kit")) {
            Kit kit = this.playerKits.getKitManager().getKit(nbtItem.getString("kit"));
            if (kit == null) {
                return;
            }
            if (click.isRightClick() && kit.isPreview()) {
                new KitPreviewMenu(player, kit).open();
                return;
            }
            this.close();
            XPKUtils.claimKit(player, kit, this.playerKitData);
        }
    }

    @Override
    protected void onDrag(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onAllClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onBottom(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        int slotNext;
        int slotLast;
        inventory.clear();
        Player player = this.getPlayer();
        Iterator<Object> iterator = this.kitsMenu.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = iterator.next();
            inventory.setItem(slot, this.kitsMenu.get(slot));
        }
        for (Kit kit : this.playerKits.getKitManager().getKits().values()) {
            if (kit.getPage() != this.page) continue;
            inventory.setItem(kit.getSlot(), XPKUtils.applySimpleTag(kit.getIcons().get(this.getIcon(player, kit, this.playerKitData)), "kit", kit.getName()));
        }
        int slotClose = this.slotsNumbers.getOrDefault("{CLOSE_SLOT}", -1);
        if (slotClose > 0) {
            ItemStack close = new ItemUtils(this.kitsMenu.get(slotClose)).displayName(this.playerKits.getLang().getString("menus.kitsMenu.close.nameItem")).build();
            inventory.setItem(slotClose, XPKUtils.applySimpleTag(close, "action", "close"));
        }
        if ((slotLast = this.slotsNumbers.getOrDefault("{LAST_SLOT}", -1).intValue()) > 0) {
            if (this.page > 1) {
                ItemStack last = new ItemUtils(this.kitsMenu.get(slotLast)).displayName(this.playerKits.getLang().getString("menus.kitsMenu.last.nameItem")).build();
                inventory.setItem(slotLast, XPKUtils.applySimpleTag(last, "action", "last"));
            } else {
                inventory.setItem(slotLast, null);
            }
        }
        if ((slotNext = this.slotsNumbers.getOrDefault("{NEXT_SLOT}", -1).intValue()) > 0) {
            if (this.page < this.playerKits.getKitManager().getLastPage()) {
                ItemStack next = new ItemUtils(this.kitsMenu.get(slotNext)).displayName(this.playerKits.getLang().getString("menus.kitsMenu.next.nameItem")).build();
                inventory.setItem(slotNext, XPKUtils.applySimpleTag(next, "action", "next"));
            } else {
                inventory.setItem(slotNext, null);
            }
        }
    }

    private String getIcon(Player player, Kit kit, PlayerKitData playerKitData) {
        if (kit.isNoHasRequirements(player)) {
            return "CANT_CLAIM";
        }
        if (!kit.getPermission().equals("none") && !player.hasPermission(kit.getPermission())) {
            return "NO_PERMISSION";
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        if (kit.isOneTime()) {
            if (kitData != null && kitData.isOneTime() && !player.hasPermission("xkits.onetime.bypass")) {
                return "ONE_TIME_CLAIMED";
            }
            return "ONE_TIME_REQUIREMENT";
        }
        if (kitData != null && kitData.getCountdown() > System.currentTimeMillis() && !player.hasPermission("xkits.countdown.bypass")) {
            return "COUNTDOWN";
        }
        return "CAN_CLAIM";
    }
}

