/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.managers;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import java.io.File;
import java.util.HashMap;
import lombok.Generated;

public class KitManager {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final HashMap<String, Kit> kits = new HashMap();
    private int lastPage = 1;

    public void load() {
        this.kits.clear();
        File kitsFolder = new File(this.playerKits.getDataFolder(), "kits");
        if (!kitsFolder.exists()) {
            kitsFolder.mkdirs();
        }
        for (File file : kitsFolder.listFiles()) {
            InsiderConfig config = new InsiderConfig(this.playerKits, "kits/" + file.getName().replace(".yml", ""), false, false);
            Kit kit = new Kit(config);
            this.kits.put(kit.getName().toLowerCase(), kit);
            this.playerKits.getLogger().info("Correctly loaded kit " + kit.getName() + ".");
        }
    }

    public Kit removeKit(String name) {
        return this.kits.remove(name.toLowerCase());
    }

    public Kit getKit(String name) {
        return this.kits.get(name.toLowerCase());
    }

    public void addKit(Kit kit) {
        this.kits.put(kit.getName().toLowerCase(), kit);
        if (kit.getPage() > this.lastPage) {
            this.lastPage = kit.getPage();
        }
    }

    @Generated
    public PlayerKits getPlayerKits() {
        return this.playerKits;
    }

    @Generated
    public HashMap<String, Kit> getKits() {
        return this.kits;
    }

    @Generated
    public int getLastPage() {
        return this.lastPage;
    }
}

