/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.xseries;

import io.github.InsiderAnh.xPlayerKits.libs.xseries.base.XBase;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.base.XRegistry;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public enum XItemFlag implements XBase<XItemFlag, ItemFlag>
{
    HIDE_ADDITIONAL_TOOLTIP("HIDE_POTION_EFFECTS"),
    HIDE_ARMOR_TRIM(new String[0]),
    HIDE_ATTRIBUTES(new String[0]),
    HIDE_DESTROYS(new String[0]),
    HIDE_DYE(new String[0]),
    HIDE_ENCHANTS(new String[0]),
    HIDE_PLACED_ON(new String[0]),
    HIDE_STORED_ENCHANTS(new String[0]),
    HIDE_UNBREAKABLE(new String[0]);

    public static final XRegistry<XItemFlag, ItemFlag> REGISTRY;
    private static final ItemFlag[] BUKKIT_VALUES;
    private final ItemFlag itemFlag;

    private XItemFlag(String ... names) {
        this.itemFlag = (ItemFlag)Data.REGISTRY.stdEnum(this, names);
    }

    public static XItemFlag of(ItemFlag itemFlag) {
        return REGISTRY.getByBukkitForm(itemFlag);
    }

    public static Optional<XItemFlag> of(String itemFlag) {
        return REGISTRY.getByName(itemFlag);
    }

    @NotNull
    public static @Unmodifiable Collection<XItemFlag> getValues() {
        return REGISTRY.getValues();
    }

    @Override
    public String[] getNames() {
        return new String[]{this.name()};
    }

    @Override
    @Nullable
    public ItemFlag get() {
        return this.itemFlag;
    }

    public void set(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{this.itemFlag});
        item.setItemMeta(meta);
    }

    public void set(ItemMeta meta) {
        meta.addItemFlags(new ItemFlag[]{this.itemFlag});
    }

    public void removeFrom(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        this.removeFrom(meta);
        item.setItemMeta(meta);
    }

    public void removeFrom(ItemMeta meta) {
        meta.removeItemFlags(new ItemFlag[]{this.itemFlag});
    }

    public Set<XItemFlag> getFlags(ItemStack item) {
        return this.getFlags(item.getItemMeta());
    }

    public Set<XItemFlag> getFlags(ItemMeta meta) {
        return meta.getItemFlags().stream().map(XItemFlag::of).collect(Collectors.toSet());
    }

    public boolean has(ItemStack item) {
        return this.has(item.getItemMeta());
    }

    public boolean has(ItemMeta meta) {
        return meta.getItemFlags().contains(this.itemFlag);
    }

    public static void hideEverything(ItemMeta meta) {
        meta.addItemFlags(BUKKIT_VALUES);
    }

    static {
        REGISTRY = Data.REGISTRY;
        BUKKIT_VALUES = ItemFlag.values();
    }

    private static final class Data {
        private static final XRegistry<XItemFlag, ItemFlag> REGISTRY = new XRegistry<XItemFlag, ItemFlag>(ItemFlag.class, XItemFlag.class, XItemFlag[]::new);

        private Data() {
        }
    }
}

