/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.util;

import io.github.InsiderAnh.xPlayerKits.libs.bson.util.ClassMap;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.Bytes;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.util.AbstractObjectSerializer;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.util.ObjectSerializer;
import java.util.Iterator;
import java.util.List;

class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private final ClassMap<ObjectSerializer> _serializers = new ClassMap();

    ClassMapBasedObjectSerializer() {
    }

    void addObjectSerializer(Class c, ObjectSerializer serializer) {
        this._serializers.put(c, serializer);
    }

    @Override
    public void serialize(Object obj, StringBuilder buf) {
        Class<?> ancestor;
        Object objectToSerialize = obj;
        if ((objectToSerialize = Bytes.applyEncodingHooks(objectToSerialize)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List<Class<?>> ancestors = ClassMap.getAncestry(objectToSerialize.getClass());
        Iterator<Class<?>> iterator = ancestors.iterator();
        while (iterator.hasNext() && (serializer = this._serializers.get(ancestor = iterator.next())) == null) {
        }
        if (serializer == null && objectToSerialize.getClass().isArray()) {
            serializer = this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + objectToSerialize.getClass());
        }
        serializer.serialize(objectToSerialize, buf);
    }
}

