/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonArray;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonBoolean;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoNamespace;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteConcernResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.UpdateRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ByteBufferBsonOutput;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.diagnostics.logging.Logger;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.diagnostics.logging.Loggers;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.ByteBufBsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.InternalConnection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.MessageSettings;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.RequestMessage;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.UpdateMessage;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.WriteProtocol;
import java.util.Collections;
import java.util.List;

class UpdateProtocol
extends WriteProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.update");
    private final UpdateRequest updateRequest;

    UpdateProtocol(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest) {
        super(namespace, ordered);
        this.updateRequest = updateRequest;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Updating documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        WriteConcernResult writeConcernResult = super.execute(connection);
        LOGGER.debug("Update completed");
        return writeConcernResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously updating documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                @Override
                public void onResult(WriteConcernResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous update completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected BsonDocument getAsWriteCommand(ByteBufferBsonOutput bsonOutput, int firstDocumentPosition) {
        List<ByteBufBsonDocument> documents = ByteBufBsonDocument.createList(bsonOutput, firstDocumentPosition);
        BsonDocument updateDocument = new BsonDocument("q", documents.get(0)).append("u", documents.get(1));
        if (this.updateRequest.isMulti()) {
            updateDocument.append("multi", BsonBoolean.TRUE);
        }
        if (this.updateRequest.isUpsert()) {
            updateDocument.append("upsert", BsonBoolean.TRUE);
        }
        return this.getBaseCommandDocument("update").append("updates", new BsonArray(Collections.singletonList(updateDocument)));
    }

    @Override
    protected RequestMessage createRequestMessage(MessageSettings settings) {
        return new UpdateMessage(this.getNamespace().getFullName(), this.updateRequest, settings);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

