/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection;

import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoCompressor;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoCredential;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoDriverInformation;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ClusterId;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ClusterSettings;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ConnectionPoolSettings;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ServerId;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ServerSettings;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.StreamFactory;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.event.CommandListener;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.event.ServerListener;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.ClusterClock;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.ClusterableServer;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.ClusterableServerFactory;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.DefaultConnectionFactory;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.DefaultConnectionPool;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.DefaultServer;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.DefaultServerMonitorFactory;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.InternalStreamConnectionFactory;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.MongoCredentialWithCache;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ClusterId clusterId;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final StreamFactory streamFactory;
    private final List<MongoCredentialWithCache> credentialList;
    private final StreamFactory heartbeatStreamFactory;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;

    public DefaultClusterableServerFactory(ClusterId clusterId, ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList) {
        this.clusterId = clusterId;
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credentialList = MongoCredentialWithCache.wrapCredentialList(credentialList);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
    }

    @Override
    public ClusterableServer create(ServerAddress serverAddress, ServerListener serverListener, ClusterClock clusterClock) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(this.clusterId, serverAddress), new InternalStreamConnectionFactory(this.streamFactory, this.credentialList, this.applicationName, this.mongoDriverInformation, this.compressorList, this.commandListener), this.connectionPoolSettings);
        connectionPool.start();
        DefaultServerMonitorFactory serverMonitorFactory = new DefaultServerMonitorFactory(new ServerId(this.clusterId, serverAddress), this.serverSettings, clusterClock, new InternalStreamConnectionFactory(this.heartbeatStreamFactory, Collections.<MongoCredentialWithCache>emptyList(), this.applicationName, this.mongoDriverInformation, Collections.<MongoCompressor>emptyList(), null), connectionPool);
        return new DefaultServer(new ServerId(this.clusterId, serverAddress), this.clusterSettings.getMode(), connectionPool, new DefaultConnectionFactory(), serverMonitorFactory, serverListener, this.commandListener, clusterClock);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

