/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonArray;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonInt32;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonString;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.AuthenticationMechanism;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoSecurityException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ServerVersion;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.Authenticator;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.CommandHelper;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.InternalConnection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.NativeAuthenticator;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.ScramShaAuthenticator;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.operation.ServerVersionHelper;

class DefaultAuthenticator
extends Authenticator {
    static final int USER_NOT_FOUND_CODE = 11;
    private static final ServerVersion FOUR_ZERO = new ServerVersion(4, 0);
    private static final ServerVersion THREE_ZERO = new ServerVersion(3, 0);
    private static final BsonString DEFAULT_MECHANISM_NAME = new BsonString(AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());

    DefaultAuthenticator(MongoCredentialWithCache credential) {
        super(credential);
        Assertions.isTrueArgument("unspecified authentication mechanism", credential.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotZero(connectionDescription)) {
            this.getLegacyDefaultAuthenticator(connectionDescription).authenticate(connection, connectionDescription);
        } else {
            try {
                BsonDocument isMasterResult = CommandHelper.executeCommand("admin", this.createIsMasterCommand(), connection);
                this.getAuthenticatorFromIsMasterResult(isMasterResult, connectionDescription).authenticate(connection, connectionDescription);
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
        }
    }

    @Override
    void authenticateAsync(final InternalConnection connection, final ConnectionDescription connectionDescription, final SingleResultCallback<Void> callback) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotZero(connectionDescription)) {
            this.getLegacyDefaultAuthenticator(connectionDescription).authenticateAsync(connection, connectionDescription, callback);
        } else {
            CommandHelper.executeCommandAsync("admin", this.createIsMasterCommand(), connection, new SingleResultCallback<BsonDocument>(){

                @Override
                public void onResult(BsonDocument result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, DefaultAuthenticator.this.wrapException(t));
                    } else {
                        DefaultAuthenticator.this.getAuthenticatorFromIsMasterResult(result, connectionDescription).authenticateAsync(connection, connectionDescription, callback);
                    }
                }
            });
        }
    }

    Authenticator getAuthenticatorFromIsMasterResult(BsonDocument isMasterResult, ConnectionDescription connectionDescription) {
        if (isMasterResult.containsKey("saslSupportedMechs")) {
            BsonArray saslSupportedMechs = isMasterResult.getArray("saslSupportedMechs");
            AuthenticationMechanism mechanism = saslSupportedMechs.contains(DEFAULT_MECHANISM_NAME) ? AuthenticationMechanism.SCRAM_SHA_256 : AuthenticationMechanism.SCRAM_SHA_1;
            return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(mechanism));
        }
        return this.getLegacyDefaultAuthenticator(connectionDescription);
    }

    private Authenticator getLegacyDefaultAuthenticator(ConnectionDescription connectionDescription) {
        if (ServerVersionHelper.serverIsAtLeastVersionThreeDotZero(connectionDescription)) {
            return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1));
        }
        return new NativeAuthenticator(this.getMongoCredentialWithCache());
    }

    private BsonDocument createIsMasterCommand() {
        BsonDocument isMasterCommandDocument = new BsonDocument("ismaster", new BsonInt32(1));
        isMasterCommandDocument.append("saslSupportedMechs", new BsonString(String.format("%s.%s", this.getMongoCredential().getSource(), this.getMongoCredential().getUserName())));
        return isMasterCommandDocument;
    }

    private MongoException wrapException(Throwable t) {
        if (t instanceof MongoSecurityException) {
            return (MongoSecurityException)t;
        }
        if (t instanceof MongoException && ((MongoException)t).getCode() == 11) {
            return new MongoSecurityException(this.getMongoCredential(), String.format("Exception authenticating %s", this.getMongoCredential()), t);
        }
        return MongoException.fromThrowable(t);
    }
}

