/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocumentReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.BsonDocumentCodec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.diagnostics.logging.Logger;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.diagnostics.logging.Loggers;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.CommandResultBaseCallback;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.ProtocolHelper;

class CommandResultCallback<T>
extends CommandResultBaseCallback<BsonDocument> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final SingleResultCallback<T> callback;
    private final Decoder<T> decoder;

    CommandResultCallback(SingleResultCallback<T> callback, Decoder<T> decoder, long requestId, ServerAddress serverAddress) {
        super(new BsonDocumentCodec(), requestId, serverAddress);
        this.callback = callback;
        this.decoder = decoder;
    }

    @Override
    protected void callCallback(BsonDocument response, Throwable t) {
        if (t != null) {
            this.callback.onResult(null, t);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Command execution completed with status " + ProtocolHelper.isCommandOk(response));
            }
            if (!ProtocolHelper.isCommandOk(response)) {
                this.callback.onResult(null, ProtocolHelper.getCommandFailureException(response, this.getServerAddress()));
            } else {
                try {
                    this.callback.onResult(this.decoder.decode(new BsonDocumentReader(response), DecoderContext.builder().build()), null);
                }
                catch (Throwable t1) {
                    this.callback.onResult(null, t1);
                }
            }
        }
    }
}

