/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.event;

import io.github.InsiderAnh.xPlayerKits.libs.mongodb.annotations.Immutable;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.diagnostics.logging.Logger;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.diagnostics.logging.Loggers;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.event.CommandFailedEvent;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.event.CommandListener;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.event.CommandStartedEvent;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.event.CommandSucceededEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Immutable
@Deprecated
public final class CommandEventMulticaster
implements CommandListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<CommandListener> commandListeners;

    public CommandEventMulticaster(List<CommandListener> commandListeners) {
        Assertions.notNull("commandListeners", commandListeners);
        Assertions.isTrue("All CommandListener instances are non-null", !commandListeners.contains(null));
        this.commandListeners = new ArrayList<CommandListener>(commandListeners);
    }

    public List<CommandListener> getCommandListeners() {
        return Collections.unmodifiableList(this.commandListeners);
    }

    @Override
    public void commandStarted(CommandStartedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandStarted(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandSucceeded(CommandSucceededEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandSucceeded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandFailed(CommandFailedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandFailed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", cur), e);
            }
        }
    }
}

