/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.geojson.codecs;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonWriter;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Codec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.configuration.CodecRegistry;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.geojson.Geometry;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.geojson.codecs.GeometryEncoderHelper;

abstract class AbstractGeometryCodec<T extends Geometry>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> encoderClass;

    AbstractGeometryCodec(CodecRegistry registry, Class<T> encoderClass) {
        this.registry = registry;
        this.encoderClass = encoderClass;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        GeometryEncoderHelper.encodeGeometry(writer, value, encoderContext, this.registry);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return GeometryDecoderHelper.decodeGeometry(reader, this.getEncoderClass());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }
}

