/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.internal;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonBinaryReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonBinaryWriter;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonBinaryWriterSettings;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonWriter;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonWriterSettings;
import io.github.InsiderAnh.xPlayerKits.libs.bson.FieldNameValidator;
import io.github.InsiderAnh.xPlayerKits.libs.bson.RawBsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.BsonValueCodecProvider;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Codec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.RawBsonDocumentCodec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.configuration.CodecRegistries;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.configuration.CodecRegistry;
import io.github.InsiderAnh.xPlayerKits.libs.bson.io.BasicOutputBuffer;
import io.github.InsiderAnh.xPlayerKits.libs.bson.io.BsonOutput;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoClientException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoNamespace;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ReadPreference;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteConcernResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.DeleteRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.InsertRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.UpdateRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.internal.Crypt;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.Connection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.QueryResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.SplittablePayload;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.MessageSettings;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.connection.SplittablePayloadBsonWriter;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.operation.ServerVersionHelper;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.validator.MappedFieldNameValidator;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.session.SessionContext;
import java.util.HashMap;
import java.util.List;

class CryptConnection
implements Connection {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final int MAX_SPLITTABLE_DOCUMENT_SIZE = 0x200000;
    private final Connection wrapped;
    private final Crypt crypt;

    CryptConnection(Connection wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public CryptConnection retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public void release() {
        this.wrapped.release();
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(this.wrapped.getDescription())) {
            throw new MongoClientException("Auto-encryption requires a minimum MongoDB version of 4.2");
        }
        BasicOutputBuffer bsonOutput = new BasicOutputBuffer();
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getDescription().getMaxDocumentSize()), bsonOutput, this.getFieldNameValidator(payload, commandFieldNameValidator, payloadFieldNameValidator));
        BsonWriter writer = payload == null ? bsonBinaryWriter : new SplittablePayloadBsonWriter(bsonBinaryWriter, (BsonOutput)bsonOutput, this.createSplittablePayloadMessageSettings(), payload, 0x200000);
        this.getEncoder(command).encode(writer, command, EncoderContext.builder().build());
        RawBsonDocument encryptedCommand = this.crypt.encrypt(database, new RawBsonDocument(bsonOutput.getInternalBuffer(), 0, bsonOutput.getSize()));
        RawBsonDocument encryptedResponse = this.wrapped.command(database, encryptedCommand, commandFieldNameValidator, readPreference, new RawBsonDocumentCodec(), sessionContext, responseExpected, null, null);
        RawBsonDocument decryptedResponse = this.crypt.decrypt(encryptedResponse);
        BsonBinaryReader reader = new BsonBinaryReader(decryptedResponse.getByteBuffer().asNIO());
        return commandResultDecoder.decode(reader, DecoderContext.builder().build());
    }

    @Override
    public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext) {
        return this.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, true, null, null);
    }

    private Codec<BsonDocument> getEncoder(BsonDocument command) {
        return REGISTRY.get(command.getClass());
    }

    private FieldNameValidator getFieldNameValidator(@Nullable SplittablePayload payload, FieldNameValidator commandFieldNameValidator, @Nullable FieldNameValidator payloadFieldNameValidator) {
        if (payload == null) {
            return commandFieldNameValidator;
        }
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put(payload.getPayloadName(), payloadFieldNameValidator);
        return new MappedFieldNameValidator(commandFieldNameValidator, rootMap);
    }

    private MessageSettings createSplittablePayloadMessageSettings() {
        return MessageSettings.builder().maxBatchCount(this.getDescription().getMaxBatchCount()).maxMessageSize(this.getDescription().getMaxMessageSize()).maxDocumentSize(this.getDescription().getMaxDocumentSize()).build();
    }

    @Override
    public <T> T command(String database, BsonDocument command, boolean slaveOk, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteConcernResult update(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int numberToReturn, int skip, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void killCursor(List<Long> cursors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void killCursor(MongoNamespace namespace, List<Long> cursors) {
        throw new UnsupportedOperationException();
    }
}

