/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.internal;

import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ReadPreference;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.binding.ConnectionSource;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.binding.ReadWriteBinding;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.internal.Crypt;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.internal.CryptConnection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.Cluster;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.Connection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.connection.ServerDescription;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.session.SessionContext;

class CryptBinding
implements ClusterAwareReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    CryptBinding(ClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.crypt = crypt;
        this.wrapped = wrapped;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new CryptConnectionSource(this.wrapped.getConnectionSource(serverAddress));
    }

    @Override
    public SessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public void release() {
        this.wrapped.release();
    }

    @Override
    public Cluster getCluster() {
        return this.wrapped.getCluster();
    }

    private class CryptConnectionSource
    implements ConnectionSource {
        private final ConnectionSource wrapped;

        CryptConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return this.wrapped.getSessionContext();
        }

        @Override
        public Connection getConnection() {
            return new CryptConnection(this.wrapped.getConnection(), CryptBinding.this.crypt);
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public void release() {
            this.wrapped.release();
        }
    }
}

