/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.internal;

import io.github.InsiderAnh.xPlayerKits.libs.bson.RawBsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.bson.conversions.Bson;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoClientException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoTimeoutException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ReadConcern;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ReadPreference;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.MongoClient;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.MongoClients;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.internal.capi.MongoCryptHelper;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    private final MongoClient client;
    private final ProcessBuilder processBuilder;

    CommandMarker(boolean isBypassAutoEncryption, Map<String, Object> options) {
        if (isBypassAutoEncryption) {
            this.processBuilder = null;
            this.client = null;
            return;
        }
        if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
            this.processBuilder = MongoCryptHelper.createProcessBuilder(options);
            MongoCryptHelper.startProcess(this.processBuilder);
        } else {
            this.processBuilder = null;
        }
        this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)options.get("mongocryptdURI")));
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        Assertions.notNull("client", this.client);
        try {
            try {
                return this.executeCommand(databaseName, command);
            }
            catch (MongoTimeoutException e) {
                if (this.processBuilder == null) {
                    throw e;
                }
                MongoCryptHelper.startProcess(this.processBuilder);
                return this.executeCommand(databaseName, command);
            }
        }
        catch (MongoException e) {
            throw this.wrapInClientException(e);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand) {
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

