/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocumentWrapper;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Encoder;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBCollection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBObject;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.UpdateRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.WriteRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.Collation;

class ReplaceRequest
extends WriteRequest {
    private final DBObject query;
    private final DBObject document;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;
    private final Collation collation;

    ReplaceRequest(DBObject query, DBObject document, boolean upsert, Encoder<DBObject> codec, Encoder<DBObject> replacementCodec, Collation collation) {
        this.query = query;
        this.document = document;
        this.upsert = upsert;
        this.codec = codec;
        this.replacementCodec = replacementCodec;
        this.collation = collation;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getDocument() {
        return this.document;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public Collation getCollation() {
        return this.collation;
    }

    @Override
    io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.WriteRequest toNew(DBCollection dbCollection) {
        return new UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.document, this.replacementCodec), WriteRequest.Type.REPLACE).upsert(this.isUpsert()).collation(this.getCollation());
    }
}

