/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonBinaryReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonWriter;
import io.github.InsiderAnh.xPlayerKits.libs.bson.ByteBufNIO;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Encoder;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.io.BasicOutputBuffer;
import io.github.InsiderAnh.xPlayerKits.libs.bson.io.ByteBufferBsonInput;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBEncoder;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBObject;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.assertions.Assertions;
import java.nio.ByteBuffer;

class DBEncoderAdapter
implements Encoder<DBObject> {
    private final DBEncoder encoder;

    DBEncoderAdapter(DBEncoder encoder) {
        this.encoder = Assertions.notNull("encoder", encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(BsonWriter writer, DBObject document, EncoderContext encoderContext) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try {
            this.encoder.writeObject(buffer, document);
            BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(buffer.toByteArray()))));
            try {
                writer.pipe(reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            buffer.close();
        }
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }
}

