/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.BasicDBObject;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBObjects;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoCommandException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.lang.Nullable;

public class CommandResult
extends BasicDBObject {
    private static final long serialVersionUID = 5907909423864204060L;
    private final BsonDocument response;
    private final ServerAddress address;

    CommandResult(BsonDocument response) {
        this(response, null);
    }

    CommandResult(BsonDocument response, @Nullable ServerAddress address) {
        this.address = address;
        this.response = Assertions.notNull("response", response);
        this.putAll(DBObjects.toDBObject(response));
    }

    public boolean ok() {
        Object okValue = this.get("ok");
        if (okValue instanceof Boolean) {
            return (Boolean)okValue;
        }
        if (okValue instanceof Number) {
            return ((Number)okValue).intValue() == 1;
        }
        return false;
    }

    @Nullable
    public String getErrorMessage() {
        Object foo = this.get("errmsg");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    @Nullable
    public MongoException getException() {
        if (!this.ok()) {
            return this.createException();
        }
        return null;
    }

    public void throwOnError() {
        if (!this.ok()) {
            throw this.createException();
        }
    }

    private MongoException createException() {
        return new MongoCommandException(this.response, this.address);
    }
}

